package org.ow2.dsrg.fm.tbpjava.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class LineCouningOutputStream extends OutputStream {
	private static final boolean DEBUG = false;
	private static final boolean DEBUG_OUTPUT = false;

	private OutputStream os; /// Where forward input if lines are counted
	private int line = 0; /// Number of lines in the output
	private PrintStream ps; 
	private boolean closing = false;
	
	public LineCouningOutputStream(String fileName) throws FileNotFoundException {
		this( new FileOutputStream(fileName));
	}
	
	
	public LineCouningOutputStream(OutputStream os) {
		this.os = os;
		ps = new PrintStream(this);
		
	}

	/**
	 * Gets number last ended line on the output. 
	 * @return Number of the '\n' character in the input stream.
	 */
	public int getLine() {
		return line;
	}

	/**
	 * @return Gets print stream which uses this stream.
	 */
	public PrintStream getPrintStream() {
		return ps;
	}

	@Override
	public void write(int b) throws IOException {
		if (b == '\n') {
			if (DEBUG) { System.out.println( LineCouningOutputStream.class.getSimpleName() + "write( b=" + b +" ) .. new line found"); }
			line++;
		}
		if (DEBUG_OUTPUT) { System.out.println( LineCouningOutputStream.class.getSimpleName() + "write( b=" + b +" )"); }
		os.write(b);
	}

	@Override
	public void write(byte b[], int off, int len) throws IOException {
		if (b == null) {
			throw new NullPointerException();
		} else if ((off < 0) || (off > b.length) || (len < 0) ||
				((off + len) > b.length) || ((off + len) < 0)) {
			throw new IndexOutOfBoundsException();
		} else if (len == 0) {
			return;
		}
		for (int i = 0 ; i < len ; i++) {
			if (b[i] == '\n') {
				line++;
				if (DEBUG) { System.out.println( LineCouningOutputStream.class.getSimpleName() + "write( b=" + b + ", off=" + off + ", len=" + len + ") .. new line found at index " + i); }
			}
		}
		if (DEBUG_OUTPUT) { System.out.println( LineCouningOutputStream.class.getSimpleName() + "write( b=" + b + ", off=" + off + ", len=" + len + ");"); }
		os.write(b,off,len);
	}
	
	public void close() {
		if (closing == false) {
			closing = true;
			ps.close(); // Causes recursive call of the close. 
			closing = false;
		} else {
			try {
				os.close();
			} catch (IOException e) {
			}
		}
	}
	
	public void println(String s) {
		ps.println(s);
	}
	
	public void println() {
		ps.println();
	}
	
	public void print(String s) {
		ps.print(s);
	}
}
