package org.ow2.dsrg.fm.tbpjava.utils;

import java.util.List;

public class DefaultJPFConfigurationGenerator {

	/**
	 * Get (default) options from jpf.properties file in command line argument format.
	 * 
	 * @param jpfArgs
	 */
	public static void addDefaultJPFConfig(List<String> jpfArgs) {
		//		# JPF configuration for "jpf-core" component
		//
		//		# path elements can either be relative to the property file location, or
		//		# use the JPF component name (e.g. "jpf-core") as a variable prefix
		//		# (e.g. "jpf-core.sourcepath=${jpf-core}/src/examples").
		//		# If a jpf.properties is to be used within NB, it has to use the variable prefix
		//		# (prepending the project root is only done during JPF init)
		//
		//		# we use the ';' separator here because it is recognized by NetBeans (as opposed
		//		# to ',')
		//
		//		# 'config_path' is set automatically by gov.nasa.jpf.Config during JPF init.
		//		# If used from within an Ant build system, 'jpf-core' has to be set explicitly
		//		# (ant does ${..} property expansion, but ignores property redefinition, so the
		//		# following line will be ignored)
		//
		/// Classpaths are added by user later
		//		jpf-core = ${config_path}
		//
		//		jpf-core.native_classpath=\
		//		  ${jpf-core}/build/jpf.jar;\
		//		  ${jpf-core}/build/jpf-annotations.jar;\
		//		  ${jpf-core}/lib/bcel.jar;\
		//		  ${jpf-core}/lib/junit-4.6.jar;\
		//		  ${jpf-core}/lib/jmockit.jar
		//
		//		jpf-core.classpath=\
		//		  ${jpf-core}/build/jpf-classes.jar;\
		//		  ${jpf-core}/build/examples
		//
		//		jpf-core.sourcepath=\
		//		  ${jpf-core}/src/examples
		//
		//		jpf-core.test_classpath=\
		//		  ${jpf-core}/build/tests
		//
		//		jpf-core.peer_packages = gov.nasa.jpf.jvm,<model>,<default>
		jpfArgs.add("+jpf-core.peer_packages=gov.nasa.jpf.jvm,<model>,<default>");
		//
		//
		//
		//		# the default jpf-core properties file with keys for which we need mandatory defaults
		//
		//		########################### 0. global part ###############################
		//
		//		# instances that are both search and VM listeners
		//		#listener = ..
		//
		//		# do we want JPF exceptions to print their stack traces (that's only for
		//		# debugging)
		//		jpf.print_exception_stack = true
		jpfArgs.add("+jpf.print_exception_stack=true");
		//
		//
		//		# this is where we can specify additional classpath entries that are
		//		# not in the system property class.path (e.g. when running JPF from
		//		# an environment that uses it's own loaders, like Eclipse plugins etc.)
		//		#jpf.native_classpath = ..
		//
		//
		//		########################### 1. Search part ###############################
		//		search.class = gov.nasa.jpf.search.DFSearch
		jpfArgs.add("+search.class=gov.nasa.jpf.search.DFSearch");
		//
		//		# This flag indicates whether state matching will only be done when a state
		//		# is revisited at a lower depth. By default this is false. If it is set to
		//		# true and no error is found in a limited-depth search then it is guaranteed
		//		# not to have such error below that depth. Note that for traditional
		//		# depth limited search this does not hold
		//		search.match_depth = false
		jpfArgs.add("+search.match_depth=false");
		//
		//		# This flag indicates whether JPF should produce more than one error
		//		# or stop at the first one
		//		search.multiple_errors = false
		jpfArgs.add("+search.multiple_errors=false");
		//
		//		# the minimum free memory bounds. If we fall below that threshold, we
		//		# stop the search
		//		search.min_free = 1M
		jpfArgs.add("+search.min_free=1M");
		//
		//		# name of the file in which we store error paths. If not set, we don't store
		//		#search.error_path = error.xml
		//
		//		# the standard properties we want to check for
		//		search.properties=\
		//		gov.nasa.jpf.jvm.NotDeadlockedProperty,\
		//		gov.nasa.jpf.jvm.NoUncaughtExceptionsProperty
		//
		//
		//		# various heuristic parameters
		//
		//		# This number specifies the maximum number of states to keep on the queue
		//		# during a heuristic search. By default it is set to -1
		//		search.heuristic.queue_limit = -1
		jpfArgs.add("+search.heuristic.queue_limit=-1");
		//
		//		# This flag indicates whether branches with counts less than branch-start
		//		# are to be ranked according to how many times they have been taken.
		//		# It is set to true by default. If it is set to false, they are all valued
		//		# the same
		//		search.heuristic.branch.count_early = true
		jpfArgs.add("+search.heuristic.branch.count_early=true");
		//		# This number determines at what point branches are heuristically valued as worse
		//		# than non-branching transitions. By default this value is 1.
		//		branch_start = 1
		jpfArgs.add("+branch_start=1");
		//
		//
		//		# This number if greater than 0 is returned as the heuristic value for
		//		# non-branching transitions. By default it is set to -1 in which case the
		//		# value of branch-start is returned instead
		//		search.heuristic.branch.no_branch_return = -1
		jpfArgs.add("+earch.heuristic.branch.no_branch_return = -1");
		//		# exclusive search listeners
		//		# search.listener =
		//
		//
		//		############################### 2. VM part ###############################
		//
		//
		//		# this is an ordered list of packages from which we try to locate native peers.
		//		# "<model>" means JPF tries the same package like the model class
		//		# "<default>" means no package at all
		//		# (this is going to be extended by jpf.properties files)
		//		#peer_packages = <model>,<default>
		//
		//
		//		vm.class = gov.nasa.jpf.jvm.JVM
		jpfArgs.add("+vm.class = gov.nasa.jpf.jvm.JVM");
		//
		//		# class used to hash/store states (if not set, states are not matched)
		//		vm.storage.class = gov.nasa.jpf.jvm.JenkinsStateSet
		jpfArgs.add("+vm.storage.class = gov.nasa.jpf.jvm.JenkinsStateSet");
		//		# class used to maintain the backtrack stack
		//		vm.backtracker.class = gov.nasa.jpf.jvm.DefaultBacktracker
		jpfArgs.add("+vm.backtracker.class = gov.nasa.jpf.jvm.DefaultBacktracker");
		//		# serializer to be used by state set (vm.storage.class)
		//		vm.serializer.class = gov.nasa.jpf.jvm.serialize.CFSerializer
		//		#vm.serializer.class = gov.nasa.jpf.jvm.serialize.AdaptiveSerializer
		//		#vm.serializer.class = gov.nasa.jpf.jvm.serialize.FilteringSerializer
		jpfArgs.add("+vm.serializer.class = gov.nasa.jpf.jvm.serialize.CFSerializer");
		//
		//		# the class that models static fields and classes
		//		vm.static.class = gov.nasa.jpf.jvm.StaticArea
		jpfArgs.add("+vm.static.class = gov.nasa.jpf.jvm.StaticArea");
		//
		//		# the class that models the heap
		//		#vm.heap.class = gov.nasa.jpf.jvm.DynamicArea
		//		vm.heap.class = gov.nasa.jpf.jvm.SparseClusterArrayHeap
		jpfArgs.add("+vm.heap.class = gov.nasa.jpf.jvm.SparseClusterArrayHeap");
		//
		//		# the class representing the list of all threads
		//		vm.threads.class = gov.nasa.jpf.jvm.ThreadList
		jpfArgs.add("+vm.threads.class = gov.nasa.jpf.jvm.ThreadList");
		//
		//		# restorer to be used by backtracker such as DefaultBacktracker UNLESS a
		//		# serializer that is also a restorer (such as CollapsingSerializer) is used.
		//		# I.e. this is only read if serializer is not used or it's not a StateRestorer
		//		vm.restorer.class = .jvm.DefaultMementoRestorer
		jpfArgs.add("+vm.restorer.class = .jvm.DefaultMementoRestorer");
		//
		//		# instruction factory
		//		vm.insn_factory.class = gov.nasa.jpf.jvm.DefaultInstructionFactory
		jpfArgs.add("+vm.insn_factory.class = gov.nasa.jpf.jvm.DefaultInstructionFactory");
		//
		//		# fields factory
		//		vm.fields_factory.class = gov.nasa.jpf.jvm.DefaultFieldsFactory
		jpfArgs.add("+vm.fields_factory.class = gov.nasa.jpf.jvm.DefaultFieldsFactory");
		//
		//		# class used to set method and field attributes at class load time
		//		vm.attributor.class = gov.nasa.jpf.jvm.DefaultAttributor
		jpfArgs.add("+vm.attributor.class = gov.nasa.jpf.jvm.DefaultAttributor");
		//
		//		# pattern list for assertion enabled classes
		//		vm.enable_assertions = *
		jpfArgs.add("+vm.enable_assertions = *");
		//
		//		# is Verify.assertTrue() a step boundary? <2do> - go away - should be unified with POR
		//		vm.visible_asserts = false
		jpfArgs.add("+vm.visible_asserts = false");
		//
		//		# do we support the Verify.ignorePath() API (to imperatively ignore paths in modeled/instrumented programs)?
		//		vm.verify.ignore_path = true
		jpfArgs.add("+vm.verify.ignore_path = true");
		//
		//		# do we want on-the-fly partial order reduction?
		//		vm.por = true
		jpfArgs.add("+vm.por = true");
		//
		//		# do we treat field access of objects that are reachable from different threads as
		//		# transaction boundaries (in case there is more tha one thread)?
		//		vm.por.field_boundaries = true
		jpfArgs.add("+vm.por.field_boundaries = true");
		//
		//		# access to fields with these patterns we never treat as transition boundaries
		//		vm.por.field_boundaries.never = java.*,javax.*,sun.*
		jpfArgs.add("+vm.por.field_boundaries.never = java.*,javax.*,sun.*");
		//
		//		# access to fields with these patterns we break on (if object is shared and
		//		# vm.por.field_boundaries is set - note it's only meaningful if sync_detection
		//		# is set because otherwse we would break anyways)
		//		vm.por.field_boundaries.break =
		jpfArgs.add("+vm.por.field_boundaries.break =");
		//
		//		# do we try to deduce if a field is supposed to be protected by a lock? In this
		//		# case, we stop to treat this field as a boundary step, but only if we see the lock
		//		vm.por.sync_detection = true
		jpfArgs.add("+vm.por.sync_detection = true");
		//
		//		# synchronization on object does not create CG if the class of that
		//		# object and the class of the method where the synchronization is
		//		# performed are in the package that matches one of the specified
		//		# patterns.  By default we do break on public methods even if this
		//		# condition is satisfied.  For public methods see
		//		# vm.por.monitor_boundaries.break.public_method
		//		+vm.por.monitor_boundaries.never=
		jpfArgs.add("+vm.por.monitor_boundaries.never=");
		//
		//		# synchronization on object always break if the class of the object
		//		# matches one of the specified patterns
		//		+vm.por.monitor_boundaries.break=
		jpfArgs.add("+vm.por.monitor_boundaries.break=");
		//
		//		# if the condition as defined with vm.por.monitor_boundaries.never is
		//		# satisfied and this flag is set to false we do not break on public
		//		# methods
		//		+vm.por.monitor_boundaries.break.public_method=true
		jpfArgs.add("+vm.por.monitor_boundaries.break.public_method=true");
		//
		//		# used to detect if a field is lock protected - only required if we use on-the-fly POR
		//		# with sync-detection
		//		vm.por.fli_factory.class = gov.nasa.jpf.jvm.StatisticFieldLockInfoFactory
		jpfArgs.add("+vm.por.fli_factory.class = gov.nasa.jpf.jvm.StatisticFieldLockInfoFactory");
		//
		//
		//		# do we assume final fields to be race-safe (not really true, esp. for
		//		# instance fields with references leaking from a ctor, but a good starting point)
		//		vm.por.skip_finals=true
		jpfArgs.add("+vm.por.skip_finals=true");
		//
		//
		//		# ClassLoaders synchronize the loading of a class.
		//		# Thus, static final fields can never be included in a race condition since only 1 thread is allowed to access the class while it is loading.
		//		# Defaulted to false to maintain backward compatibility in JPF
		//		vm.por.skip_static_finals=false
		jpfArgs.add("+vm.por.skip_static_finals=false");
		//
		//
		//		# When an object's constructor has returned, then the final fields can not be changed.
		//		# Thus, instance final fields can never be included in a race condition (unless the this reference is leaked from a constructor)
		//		# Defaulted to false to maintain backward compatibility in JPF
		//		vm.por.skip_constructed_finals=false
		jpfArgs.add("+vm.por.skip_constructed_finals=false");
		//
		//
		//		# The original implementation caused a POR boundary to be created on all synchronized statements.
		//		# Setting this to true skips POR boundaries on synchronized statements on objects local to the thread.
		//		vm.por.skip_local_sync=false
		jpfArgs.add("+vm.por.skip_local_sync=false");
		//
		//
		//		# do we reclaim unused memory (run garbage collection)
		//		vm.gc = true
		jpfArgs.add("+vm.gc = true");
		//
		//		# threshold after which number of allocations to perform a garbage collection
		//		# (even within the same transition, to avoid lots of short living objects)
		//		# -1 means never
		//		vm.max_alloc_gc = -1 
		jpfArgs.add("+vm.max_alloc_gc = -1 ");
		//
		//		# do we run finalizers on collected objects (only makes sense with garbage collection)
		//		vm.finalize = false
		jpfArgs.add("+vm.finalize = false");
		//
		//		# do we want to halt execution on each throw of an exception that matches
		//		# one of the given prefixes, w/o looking for exception handlers?
		//		# (useful for empty handler blocks, over-permissive catches or generally
		//		# misused exceptions)
		//		#vm.halt_on_throw = any
		//
		//		# class that is used to create scheduling relevant choice generators.
		//		# this will replace the scheduler
		//		vm.scheduler_factory.class = gov.nasa.jpf.jvm.DefaultSchedulerFactory
		jpfArgs.add("+vm.scheduler_factory.class = gov.nasa.jpf.jvm.DefaultSchedulerFactory");
		//
		//		# print output as it is generated during the search (for all paths)
		//		vm.tree_output = true
		jpfArgs.add("+vm.tree_output = true");
		//
		//		# collect output inside the stored path (to create program trace outout)
		//		vm.path_output = false
		jpfArgs.add("+vm.path_output = false");
		//
		//		# do we want to store the whole path no matter if we report them
		//		vm.store_steps=false
		jpfArgs.add("+vm.store_steps=false");
		//
		//		# untracked property
		//		vm.untracked = true
		jpfArgs.add("+vm.untracked = true");
		//
		//		# from where do we initialize the system properties
		//		#  selected - keys specified as vm.system.properties, values from host
		//		#  file - Java properties file (key=value pairs)
		//		#  host - all system properties from underlying host VM
		//		vm.sysprop.source = selected
		jpfArgs.add("+vm.sysprop.source = selected");
		//
		//		# pathname of property file with system properties
		//		#vm.sysprop.file =
		//
		//		# list of key names to load from host VM
		//		#vm.sysprop.keys =
		//
		//		# determines what is returned from System.currentTimeMillis() and System.nanoTime()
		//		# the valid options are ConstantZero, ConstantStartTime, ConstantConfig and SystemTime
		//		# ConstantZero causes both methods to always return 0
		//		# ConstantStartTime causes both methods to return the start time of JPF according the the machine's time
		//		# ConstantConfig causes both methods to return the configured values in vm.time.currentTimeMillis and vm.time.nanoTime properties
		//		# SystemTime causes both methods to return the machine's current time
		//		# Note: SystemTime can cause a huge state explosion if the program retains the methods' return value
		//		vm.time.model=SystemTime
		//		#vm.time.currentTimeMillis=0
		//		#vm.time.nanoTime=0
		jpfArgs.add("+vm.time.model=SystemTime");
		//
		//		# if this is set to true, we throw an exception if we encounter any orphan native peer methods
		//		vm.no_orphan_methods = false
		jpfArgs.add("+vm.no_orphan_methods = false");
		//
		//		############################### 3. CG part ###############################
		//
		//		#"def" the default value of randomize choices is not randomized
		//		#"path" randomizes choices using preset user-specified seed
		//		#"random" randomizes choices using a different seed at each trial
		//		cg.randomize_choices = def
		jpfArgs.add("+cg.randomize_choices = def");
		//
		//		# if this is set, we create choice generators even if there is only a single
		//		# choice. This is to ensure state storage/matching at all locations where a
		//		# choice generator *could* be created. The default should be to turn it off though,
		//		# since this can produce a lot of additional states (esp. with threads)
		//		cg.break_single_choice = false
		jpfArgs.add("+cg.break_single_choice = false");
		//
		//
		//		# default BooleanChoiceGenerator sequence: do we start with 'false'
		//		cg.boolean.false_first = true
		jpfArgs.add("+cg.boolean.false_first = true");
		//
		//		# do we want java.util.Random. nextXX() enumerate choices, or just return a single value?
		//		# (isn't implemented for all types yet)
		//		cg.enumerate_random=false
		jpfArgs.add("+cg.enumerate_random=false");
		//
		//		# maximum number of processors returned by Runtime.availableProcessors(). If this is
		//		# greater than 1, the call represents a ChoiceGenerator
		//		cg.max_processors=1
		jpfArgs.add("+cg.max_processors=1");
		//
		//		# creates a CG upon Thread.start, i.e. breaks the starting transition. Note this is
		//		# required for data race detection (which depends on detecting access of shared objects)
		//		cg.threads.break_start=true
		jpfArgs.add("+cg.threads.break_start=true");
		//
		//		# if this option is true, CG is not created when yield() (Thread API)
		//		# is called
		//		cg.threads.break_yield=true
		jpfArgs.add("+cg.threads.break_yield=true");
		//
		//		# if this option is true, CG is not created when sleep() (Thread API)
		//		# is called
		//		cg.threads.break_sleep=true
		jpfArgs.add("+cg.threads.break_sleep=true");
		//
		//		# set if we shold also break on array instructions, e.g. to detect races
		//		# for array elements. This is off by default because it can cause serious
		//		# state explosion
		//		cg.threads.break_arrays=false
		jpfArgs.add("+cg.threads.break_arrays=false");
		//
		//
		//		############################### 3. Report Part ###############################
		//		log.handler.class=gov.nasa.jpf.util.LogHandler
		jpfArgs.add("+log.handler.class=gov.nasa.jpf.util.LogHandler");
		//
		//		# Windows seem to have a different default
		//		log.level=warning
		jpfArgs.add("+log.level=warning");
		//
		//		report.class=gov.nasa.jpf.report.Reporter
		jpfArgs.add("+report.class=gov.nasa.jpf.report.Reporter");
		//		report.publisher=console
		jpfArgs.add("+report.publisher=console");
		//
		//		report.console.class=gov.nasa.jpf.report.ConsolePublisher
		jpfArgs.add("+report.console.class=gov.nasa.jpf.report.ConsolePublisher");
		//
		//		# this prints out repository information if the 'jpf' topic is set (for debugging)
		//		#jpf.report.show_repository=true
		//
		//		#property violation reporting is configured separately
		//		report.console.start=jpf,sut
		jpfArgs.add("+report.console.start=jpf,sut");
		//
		//		report.console.transition=
		jpfArgs.add("+report.console.transition=");
		//		report.console.constraint=constraint,snapshot
		jpfArgs.add("+report.console.constraint=constraint,snapshot");
		//
		//		report.console.property_violation=error,snapshot
		jpfArgs.add("+report.console.property_violation=error,snapshot");
		//		report.console.show_steps=true
		jpfArgs.add("+report.console.show_steps=true");
		//		report.console.show_method=true
		jpfArgs.add("+report.console.show_method=true");
		//		report.console.show_code=false
		jpfArgs.add("+report.console.show_code=false");
		//
		//		report.console.finished=result,statistics
		jpfArgs.add("+report.console.finished=result,statistics");
		//
		//		#jpf.report.console.show_steps=true
		//		#jpf.report.console.show_method=true
		//		#jpf.report.console.show_code=true
		//
		//		report.xml.class=gov.nasa.jpf.report.XMLPublisher
		jpfArgs.add("+report.xml.class=gov.nasa.jpf.report.XMLPublisher");
		//
		//		report.html.class=gov.nasa.jpf.report.HTMLPublisher
		jpfArgs.add("+report.html.class=gov.nasa.jpf.report.HTMLPublisher");
		//		report.html.start=jpf,sut,platform,user,dtg,config
		jpfArgs.add("+report.html.start=jpf,sut,platform,user,dtg,config");
		//		report.html.constraint=constraint
		jpfArgs.add("+report.html.constraint=constraint");
		//		report.html.property_violation=
		jpfArgs.add("+report.html.property_violation=");
		//		report.html.finished=result,statistics,error,snapshot,output
		jpfArgs.add("+report.html.finished=result,statistics,error,snapshot,output");
		//
		//
		//		############################### 4. Listener part #############################
		//
		//		# imperative list of listeners
		//		#listener=
		//
		//		listener.autoload=\
		//		  gov.nasa.jpf.NonNull,\
		//		  gov.nasa.jpf.Const
		jpfArgs.add("+listener.autoload=gov.nasa.jpf.NonNull,gov.nasa.jpf.Const");
		//
		//		listener.gov.nasa.jpf.NonNull=gov.nasa.jpf.tools.NonNullChecker
		jpfArgs.add("+listener.gov.nasa.jpf.NonNull=gov.nasa.jpf.tools.NonNullChecker");
		//		listener.gov.nasa.jpf.Const=gov.nasa.jpf.tools.ConstChecker
		jpfArgs.add("+listener.gov.nasa.jpf.Const=gov.nasa.jpf.tools.ConstChecker");
		//
		//
		//		### PreciseRaceDetector
		//
		//		# we don't check for races in standard libraries
		//		race.exclude=java.*,javax.*
		jpfArgs.add("+race.exclude=java.*,javax.*");
		//
		//
		//		############################### 5. test part #############################
		//
		//		test.report.console.finished=result 
		jpfArgs.add("+test.report.console.finished=result");
	}
}
