package org.ow2.dsrg.fm.tbpjava.envgen;

import java.io.PrintStream;

/**
 * Takes care about indentation. 
 * Indenter is shared between classes processing one output file. 
 * For each output file create new Indenter.
 * <br>
 * Note: One indentation level is represented by sequence of {@link #INDENT_CHARACTER} character 
 * which is {@link #INDENT_LEVEL_SIZE} times repeated
 */
public class Indenter {
	/// Number of characters in one indent level
	static final public int  INDENT_LEVEL_SIZE = 4;
	/// Char that is used for indentation
	static final public char INDENT_CHARACTER = ' ';

	/// Level of indenting
	private int indentLevel = 0;
	/// Stream where print indentation
	private PrintStream out;

	/**
	 * Creates indenter class
	 * @param out Stream where indentation is printed (when {@link #indent()} is called)
	 */
	public Indenter(PrintStream out) {
		this.out = out;
	}
	
	/// Increase level of indentation
	public void addLevel() {
		indentLevel++;
	}
	
	/// Remove one level of indentation
	public void removeLevel() {
		if ( indentLevel > 0 ) {
			indentLevel--;
		}
	}

	/**
	 * Class for easy storing and restoring indentation level.  
	 */
	static public class IndentLevel {
		private int indentLevel = 1;
		/// Private constructor to deny users create own indentation level (BlackBox view)
		private IndentLevel(int indentLevel) {
			this.indentLevel = indentLevel;
		}
		/**
		 * Gets level of indentation.
		 * @return Gets level of indentation.
		 */
		public int getIndentLevel() {
			return indentLevel;
		}
	}
	

	/** 
	 * Gets current level of indentation
	 * @return Class representing actual indentation level
	 */
	public IndentLevel getIndentLevel() {
		return new IndentLevel(indentLevel);
	}
	
	/**
	 * Restores indentation to level when param newLevel was created.
	 * @param newLevel New indentation level 
	 */
	public void restoreIndentLevel(IndentLevel newLevel) {
		if ( newLevel == null ) {
			return;
		}
		indentLevel = newLevel.getIndentLevel(); 
	}
	
	/**
	 * Prints indentation into output.
	 */
	public void indent() {
		for(int i = 0; i < indentLevel * INDENT_LEVEL_SIZE; i++) {
			out.print(INDENT_CHARACTER);
		}
	}


}
