package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.ow2.dsrg.fm.tbplib.util.Typedef;

public class TypeDef {
	
	Typedef sourceType;
	
	private final int entriesCount;
	
	/// Record for one from values of source type
	public class TypeEntryRecord {
		int value;
		int xorValue;
	}
	
	private final Map<String, TypeEntryRecord> name2valueMapping;
	private final Map<Integer, String> xorValue2Name;
	private final List<String> value2Name;
	private final List<Integer> value2XorValue;
	
	TypeDef(Typedef sourceType) {
		assert sourceType != null;
		this.sourceType = sourceType;
		
		List<String> sourceTypeEnums = sourceType.getEnums();
		entriesCount = sourceTypeEnums.size();
		
		name2valueMapping = new HashMap<String, TypeEntryRecord>(entriesCount + entriesCount / 2);
		xorValue2Name = new HashMap<Integer, String>(entriesCount + entriesCount / 2);
		
		value2Name = new ArrayList<String>(entriesCount);
		value2XorValue = new ArrayList<Integer>(entriesCount);
		
		int firstEmptyValueIndex = 0;
		Random rnd = new Random();
		
		for(String name : sourceTypeEnums) {
			TypeEntryRecord ter = new TypeEntryRecord();
			ter.value = firstEmptyValueIndex++;
			//ter.xorValue = value.hashCode(); // Alternative choice
			ter.xorValue = rnd.nextInt();
			
			name2valueMapping.put(name, ter);
			xorValue2Name.put(ter.xorValue, name);
			value2Name.add(ter.value, name);
			value2XorValue.add(ter.value, ter.xorValue);
		}
	}
	
	public Typedef getSourceType() {
		return sourceType;
	}
	
	public TypeEntryRecord getValueRecord(String value) {
		return name2valueMapping.get(value);
	}
	
	
	public int getXorValue(int value) {
		assert value >= 0 && value < entriesCount;
		return value2XorValue.get(value);
	}
	
	public String getEnumName(int value) {
		assert value >= 0 && value < entriesCount;
		return value2Name.get(value);
	}
}
