package org.ow2.dsrg.fm.tbpjava.checker;

import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.ow2.dsrg.fm.tbplib.EventTable;
import org.ow2.dsrg.fm.tbplib.EventTableImpl;
import org.ow2.dsrg.fm.tbplib.ltsa.Automaton;
import org.ow2.dsrg.fm.tbplib.ltsa.Edge;
import org.ow2.dsrg.fm.tbplib.ltsa.State;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAAutomaton;

import org.ow2.dsrg.fm.tbplib.util.DOTPrintStream;

/**
 * Helper class with static methods to print out graphs of provisions, reactions 
 * and threads.
 *
 * Note: This is slightly modified version of TPBLib version.
 * Edge and vertices names contains runtime names for easier debugging.
 *
 */
public class AutomatonToDot {

	private static int nodeid = 0;
	public static void toDot(Automaton a, EventTable et, OutputStream stream) {
		
		Set<State> finals = a.getFinalStates();
		Set<State> visited = new HashSet<State>();
		Map<State,Integer> s_to_i = new HashMap<State, Integer>();
		Deque<Iterator<Edge>> stack = new ArrayDeque<Iterator<Edge>>();
		DOTPrintStream out = new DOTPrintStream(stream);
		
		out.println("node [height=0.2 width=0.2 shape = circle];");
		
		
		State start = a.getStartState();
		printNode(out, start, finals, start, s_to_i, (EventTableImpl) et);
		visited.add(start);
		stack.push(start.getEdges().iterator());
		
		while(!stack.isEmpty()){
			Iterator<Edge> peek = stack.peek();
			if(peek.hasNext()){
				State next = peek.next().getTarget();
				if(!visited.contains(next)){
					printNode(out, next, finals, start, s_to_i, (EventTableImpl) et);
					visited.add(next);
					stack.push(next.getEdges().iterator());
				}
			} else {
				stack.pop();
			}
		}
		
		out.DOTclose();
		nodeid = 0;
	}
		
	private static int getId(State s, Map<State, Integer> s_to_i) {
		Integer integer = s_to_i.get(s);
        if(integer == null){
        	s_to_i.put(s, nodeid);
        	integer = nodeid++;
        }
        return integer;
	}
	
	private static void printNode(DOTPrintStream out, State ds,
			Set<State> finals, State start, Map<State, Integer> s_to_i, 
			EventTableImpl et) {
		
        if (ds.equals(start)) {
            out.peripheries = 2;
        } else {
            out.peripheries = 1;
        }
        
        out.filled = finals.contains(ds);
        
        int dsid = getId(ds, s_to_i);
        out.node(dsid, ds.toString());
        
        for(Edge e : ds.getEdges()){
       		EventTableImpl.Event event = et.getEvent(e.getSymbol());
       		
       		String edge_label;
       		edge_label = Integer.toString(e.getSymbol()); //et.getEvent(e.getSymbol()).toString();
       		edge_label = edge_label + " Event=" + event;
       		edge_label = edge_label + " EventClass=" + (event!=null?event.getClass().getSimpleName():"???");
       		edge_label = edge_label + " " + e.toString();
        	out.edge(dsid, getId(e.getTarget(), s_to_i), edge_label);
        }

        out.peripheries = 1;
        out.filled = false;			
	}

//TODO: lot of duplicity in two versions of toDot  	
	public static void toDot(LTSAAutomaton a, OutputStream stream) {

		Set<State> visited = new HashSet<State>();
		Map<State,Integer> s_to_i = new HashMap<State, Integer>();
		Deque<Iterator<Edge>> stack = new ArrayDeque<Iterator<Edge>>();
		DOTPrintStream out = new DOTPrintStream(stream);
		
		out.println("node [height=0.2 width=0.2 shape = circle];");
		
		
		State start = a.getStart();
		printLSTANode(out, start, start, s_to_i);
		visited.add(start);
		stack.push(start.getEdges().iterator());
		
		while(!stack.isEmpty()){
			Iterator<Edge> peek = stack.peek();
			if(peek.hasNext()){
				State next = peek.next().getTarget();
				if(!visited.contains(next)){
					printLSTANode(out, next, start, s_to_i);
					visited.add(next);
					stack.push(next.getEdges().iterator());
				}
			} else {
				stack.pop();
			}
		}
		
		out.DOTclose();
		nodeid = 0;
	}

	private static void printLSTANode(DOTPrintStream out, State ds,
			State start, Map<State, Integer> s_to_i){

        if (ds.equals(start)) {
            out.peripheries = 2;
        } else {
            out.peripheries = 1;
        }
        
        out.filled = false;
        
        int dsid = getId(ds, s_to_i);
        out.node(dsid, ds.toString());
        
        for(Edge e : ds.getEdges()){
        	String edge_label;
        	edge_label = e.getData() == null ? "NULL" : e.getData().toString();
        	edge_label = edge_label + " " + e.toString();
        	out.edge(dsid, getId(e.getTarget(), s_to_i), edge_label);
        }

        out.peripheries = 1;
        out.filled = false;			
	}
}
