package de.itemis.qimpress.showcase.pricing_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * Each object of this class holds a type customers can be categorized in.
 * @author Claudius Haecker
 *
 */
@Entity
@Table(name = "customer_type")
public class CustomerType implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 4504718052533111168L;
    private String customerTypeId;
    private String customerTypeName;
    private String customerTypeKey;
    private Date dateCreated;
    private Date dateLastModified;

    public CustomerType() {
    }

    public CustomerType(String customerTypeId, String customerTypeName, String customerTypeKey, Date dateCreated,
            Date lastModified) {
        this.customerTypeId = customerTypeId;
        this.customerTypeName = customerTypeName;
        this.customerTypeKey = customerTypeKey;
        this.dateCreated = dateCreated;
        this.dateLastModified = lastModified;
    }

    @Id
    @OneToMany(mappedBy = "customer")
    @JoinColumn(name = "customer_type_id")
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "customer_type_id")
    public String getCustomerTypeId() {
        return customerTypeId;
    }

    public void setCustomerTypeId(String customerTypeId) {
        this.customerTypeId = customerTypeId;
    }

    @Column(name = "customer_type_name")
    public String getCustomerTypeName() {
        return customerTypeName;
    }

    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }

    @Column(name = "customer_type_key")
    public String getCustomerTypeKey() {
        return customerTypeKey;
    }

    public void setCustomerTypeKey(String customerTypeKey) {
        this.customerTypeKey = customerTypeKey;
    }

    /**
* returns the date set by the database on each row when <code>this</code> was inserted into the database.
* @return the creation date
*/
@Column(name = "date_created", nullable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

}
