package de.itemis.qimpress.showcase.pricing_simulator.be.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Class representing volume discount with lower and upper bounds
 * for the product quantity in the order.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "volume_discount")
public class VolumeDiscount {

    /** primary key */
    private Long id;

    /** creation date */ 
    private Date dateCreated;
    /** last modified */
    private Date dateLastModified;

    /** lower quantity bound */
    private Integer fromQuantity;
    /** upper quantity bound */
    private Integer toQuantity;
    /** discount rate */
    private float percentage;

    public VolumeDiscount() {
        super();
    }

    public VolumeDiscount(Long id) {
        super();
        this.id = id;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "volume_discount_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * returns the date set by the database on each row when <code>this</code> was inserted into the database.
     * @return the creation date
     */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * @return the lastModified
     */
    @Column(name = "date_last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    /**
     * @return the fromQuantity
     */
    @Column(name = "volume_discount_from_quantity")
    public Integer getFromQuantity() {
        return fromQuantity;
    }

    /**
     * @param fromQuantity the fromQuantity to set
     */
    public void setFromQuantity(Integer fromQuantity) {
        this.fromQuantity = fromQuantity;
    }

    /**
     * @return the toQuantity
     */
    @Column(name = "volume_discount_to_quantity")
    public Integer getToQuantity() {
        return toQuantity;
    }

    /**
     * @param toQuantity the toQuantity to set
     */
    public void setToQuantity(Integer toQuantity) {
        this.toQuantity = toQuantity;
    }

    /**
     * @return the percentage
     */
    @Column(name = "volume_discount_percentage")
    public float getPercentage() {
        return percentage;
    }

    /**
     * @param percentage the percentage to set
     */
    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

}
