/**
 * 
 */
package de.itemis.qimpress.showcase.pricing_simulator.be.domain;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * Class representing standard or country-specific product price.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "product_price")
public class ProductPrice {

    /** primary key */
    private Long id;

    /** creation date */
    private Date dateCreated;
    /** last modification date */
    private Date dateLastModified;
    
    /** product code */
    private String productCode;
    /** country iso code; equals to null for product standard price **/
    private String countryIsoCode;
    /** product price */
    private BigDecimal price;
    /** product price currency */
    private Currency currency;
    
    public ProductPrice() {
        super();
    }

    public ProductPrice(Long id) {
        super();
        this.id = id;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "product_price_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the productCode
     */
    @Column(name = "product_code")
    public String getProductCode() {
        return productCode;
    }

    /**
     * @param productCode the productCode to set
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    /**
     * @return the countryIsoCode
     */
    @Column(name = "country_iso_code")
    public String getCountryIsoCode() {
        return countryIsoCode;
    }

    /**
     * @param countryIsoCode the countryIsoCode to set
     */
    public void setCountryIsoCode(String countryIsoCode) {
        this.countryIsoCode = countryIsoCode;
    }

    /**
     * @return the price
     */
    @Column(name = "product_price")
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * @param price the price to set
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    /**
     * @return the currency
     */
    @ManyToOne
    @JoinColumn(name = "product_price_currency")
    public Currency getCurrency() {
        return currency;
    }

    /**
     * @param currency the currency to set
     */
    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    /**
     * @return the dateCreated
     */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * @return the dateLastModified
     */
    @Column(name = "date_last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     * @param dateLastModified the dateLastModified to set
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    /**
     * Checks if the object represents a standard, country-independent price.
     * 
     * @return true, if standard price
     */
    @Transient
    public boolean isStandardPrice() {
        return (this.countryIsoCode == null);
    }
}
