/**
 * 
 */
package de.itemis.qimpress.showcase.pricing_simulator.be.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "customer_type_discount")
public class CustomerTypeDiscount {

    /** primary key */
    private Long id;

    /** creation date */  
    private Date dateCreated;
    /** last modification date */
    private Date dateLastModified;

    /** customer type name */
    private String customerType;
    /** discount rate */
    private float percentage;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "customer_type_discount_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * returns the date set by the database on each row when <code>this</code> was inserted into the database.
     * @return the creation date
     */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * @return the dateLastModified
     */
    @Column(name = "date_last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    /**
     * @return the customerType
     */
    @Column(name = "customer_type", unique = true)
    public String getCustomerType() {
        return customerType;
    }

    /**
     * @param customerType the customerType to set
     */
    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    /**
     * @return the percentage
     */
    @Column(name = "customer_type_discount_percentage")
    public float getPercentage() {
        return percentage;
    }

    /**
     * @param percentage the percentage to set
     */
    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

}
