/**
 * 
 */
package de.itemis.qimpress.showcase.pricing_simulator.be.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Class representing currency description.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "currency")
public class Currency {

    /** primary key */
    private Long id;
    
    /** creation date */
    private Date dateCreated;
    /** last modification date */
    private Date dateLastModified;
    
    /** currency ISO code */
    private String isoCode;
    /** currency sign */
    private String sign;
    
    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "currency_id")
    public Long getId() {
        return id;
    }
    
    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the isoCode
     */
    @Column(name = "currency_iso_code", unique = true, nullable = false)
    public String getIsoCode() {
        return isoCode;
    }

    /**
     * @param isoCode the isoCode to set
     */
    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    /**
     * @return the sign
     */
    @Column(name = "currency_sign")
    public String getSign() {
        return sign;
    }

    /**
     * @param sign the sign to set
     */
    public void setSign(String sign) {
        this.sign = sign;
    }

    /**
     * @return the dateCreated
     */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * @return the dateLastModified
     */
    @Column(name = "date_last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     * @param dateLastModified the dateLastModified to set
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

}
