/**
 * 
 */
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * DAO-operations interface for {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice}.
 * Allows to find country-specific ProductPrice for a given product.
 * 
 * @author Wladimir Safonov
 *
 */
public interface ProductPriceDao {

    /**
     * Finds a country-specific product price. If there is no country-specific price, 
     * the product standard price will be taken.
     * 
     * @param productCode code of the product to look the price for
     * @param countryCode ISO country code to look the product price for
     * @return country-specific or standard 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice} 
     * @throws DaoException if data access results in an error
     */
    public ProductPrice findCountryPrice(String productCode, String countryCode) throws DaoException;
    
    /**
     * Loads a list of all stored country-specific prices for all products. 
     * Product standard prices are not included.
     * 
     * @return list of all country-specific prices for all products
     * @throws DaoException if data access results in an error
     */
    public List<ProductPrice> getAllCountryPrices() throws DaoException;
    
}
