package de.itemis.qimpress.showcase.crm_simulator.be.service;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.crm_simulator.be.dao.CountriesDao;
import de.itemis.qimpress.showcase.crm_simulator.be.dao.CustomerCategoryDao;
import de.itemis.qimpress.showcase.crm_simulator.be.dao.CustomerDao;
import de.itemis.qimpress.showcase.crm_simulator.be.dao.CustomerTypeDao;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.Country;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerCategory;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * <p>This service provides access to the data of the
 * customer relationship system.</p>
 *  
 * <p><code>getCountries()</code>, <code>getCustomerCategories()</code>
 * and <code>getCustomerTypes()</code> provide categories into which all customers are
 * distributed by the criteria invoice country, delivery country, category
 * and type respectively.</p>
 * 
 * <p><code>queryCustomers(null)</code> returns all custumers in the CRM while
 * <code>queryCustomers(filter)</code> filters this list. The categories mentioned above
 * can be used as filter criteria.</p>
 * @author Claudius Haecker
 *
 */
public class CRMManagerImpl implements CRMManager {
    /**
    * Logger for CRMManagerImpl.
    */
    private static final Logger LOG = Logger.getLogger(CRMManagerImpl.class);
    private CountriesDao countriesDao;
    private CustomerTypeDao customerTypeDao;
    private CustomerCategoryDao customerCategoryDao;
    private CustomerDao customerDao;

    /**
     * @param customerDao the customerDao to set
     */
    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    public void setCustomerCategoryDao(CustomerCategoryDao customerCategoryDao) {
        this.customerCategoryDao = customerCategoryDao;
    }

    public void setCustomerTypeDao(CustomerTypeDao customerTypeDao) {
        this.customerTypeDao = customerTypeDao;
    }

    public void setCountriesDao(CountriesDao countriesDao) {
        this.countriesDao = countriesDao;
    }

    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<Country> getCountries() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getCountries");
        }
        List<Country> countries = null;
        try {
            countries = countriesDao.getCountries();
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE);
        }
        return countries;
    }

    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<CustomerType> getCustomerTypes() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getCustomerTypes");
        }
        List<CustomerType> customerTypes;
        try {
            customerTypes = customerTypeDao.getCustomerTypes();
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        return customerTypes;
    }

    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<CustomerCategory> getCustomerCategories() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getCustomerCategories");
        }
        List<CustomerCategory> customerCategories;
        try {
            customerCategories = customerCategoryDao.getCustomerCategories();
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        return customerCategories;
    }

    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<Customer> queryCustomers(CustomerFilter filter) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> queryCustomers");
        }

        List<Customer> customer;
        try {
            customer = customerDao.queryCustomers(filter);
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
            }
        return customer;
    }

}
