package de.itemis.qimpress.showcase.crm_simulator.be.filter;

import java.io.Serializable;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Country;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerCategory;
import de.itemis.qimpress.showcase.crm_simulator.be.domain.CustomerType;

/**
 * This object holds the data the customer filters for.
 * @author Claudius Haecker
 */
public class CustomerFilter implements Serializable {

    private static final long serialVersionUID = -596998765946656434L;
    private static final Logger LOG = Logger.getLogger(CustomerFilter.class);

    private String customerNamePattern;
    private String customerNumberPattern;
    private CustomerCategory category;
    private CustomerType customerType;
    private Country deliveryCountry;
    private Country invoiceCountry;

    /**
     * @return the customerNamePattern
     */
    public String getCustomerNamePattern() {
        return customerNamePattern;
    }

    /**
     * @param customerNamePattern the customerNamePattern to filter for
     */
    public void setCustomerNamePattern(String customerNamePattern) {
        this.customerNamePattern = customerNamePattern;
    }

    /**
     * @return the customerNumberPattern
     */
    public String getCustomerNumberPattern() {
        return customerNumberPattern;
    }

    /**
     * @param customerNumberPattern a Pattern for the customerNumber to filter for
     */
    public void setCustomerNumberPattern(String customerNumberPattern) {
        this.customerNumberPattern = customerNumberPattern;
    }

    //    
    //    public void setCatagoryName(String name) {
    //        getCategory().setCustomerCategoryName(name);
    //    }
    //    
    /**
     * @return the category
     */
    public CustomerCategory getCategory() {
        if (this.category == null) {
            this.category = new CustomerCategory();
        }
        return category;
    }

    /**
     * @param category the category to filter for
     */
    public void setCategory(CustomerCategory category) {
        this.category = category;
    }

    /**
     * 
     * @param categoryName the name of the category to filter for
     */
    public void setCustomerCategoryByName(String categoryName) {
        getCategory().setCustomerCategoryName(categoryName);
    }

    /**
     * instantiates a new customerCategory object if necessary
     * and sets the customerCategoryKey property.
     * @param key the key parameter of the Category
     */
    public void setCustomerCategoryByKey(String key) {
        getCategory().setCustomerCategoryKey(key);
    }

    /**
     * @return the type
     */
    public CustomerType getCustomerType() {
        if (this.customerType == null) {
            this.customerType = new CustomerType();
        }
        return customerType;
    }

    /**
     * @param customerType the customerType to filter for
     */
    public void setCustomerType(CustomerType customerType) {
        this.customerType = customerType;
    }

    /**
     * 
     * @param typeName the name of the customerType to filter for
     */
    public void setCustomerTypeByName(String typeName) {
        getCustomerType().setCustomerTypeName(typeName);
    }

    /**
     * instantiates a new customerType object if necessary
     * and sets the customerTypeKey property.
     * @param key the key parameter of the type
     */
    public void setCustomerTypeByKey(String key) {
        getCustomerType().setCustomerTypeKey(key);
    }

    /**
     * @return the deliveryCountry
     */
    public Country getDeliveryCountry() {
        if (deliveryCountry == null) {
            deliveryCountry = new Country();
        }
        return deliveryCountry;
    }

    /**
     * @param deliveryCountry the deliveryCountry to filter for
     */
    public void setDeliveryCountry(Country deliveryCountry) {
        this.deliveryCountry = deliveryCountry;
    }

    /**
     * @param deliveryCountryName the name of the delivery Country to filter for
     */
    public void setDeliveryCountryByName(String deliveryCountryName) {
        getDeliveryCountry().setName(deliveryCountryName);
    }

    /**
     * @param isoCode the iso code of the delivery country to filter for
     */
    public void setDeliveryCountryByIsoCode(String isoCode) {
        getDeliveryCountry().setIsoCode(isoCode);
    }

    /**
     * @return the invoiceCountry
     */
    public Country getInvoiceCountry() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  getInvoiceCountry");
        }
        if (invoiceCountry == null) {
            invoiceCountry = new Country();
        }
        return invoiceCountry;
    }

    /**
     * @param invoiceCountry the invoice country to filter for
     */
    public void setInvoiceCountry(Country invoiceCountry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  setInvoiceCountry");
        }
        this.invoiceCountry = invoiceCountry;
    }

    /**
     * @param invoiceCountryName the name of the invoice country to filter for
     */
    public void setInvoiceCountryByName(String invoiceCountryName) {
        getInvoiceCountry().setName(invoiceCountryName);
    }

    /**
     * @param isoCode the iso code of the invoice country to filter for
     */
    public void setInvoiceCountryByIsoCode(String isoCode) {
        getInvoiceCountry().setIsoCode(isoCode);
    }
}
