package de.itemis.qimpress.showcase.crm_simulator.be.exceptions;

/**
 * Exception wrapping exceptions (logical constraints and errors) of the
 * business layer.
 * @author Ina Jarocki
 */
@SuppressWarnings("serial")
public class ApplicationException extends Exception {
    /**
     * Enumeration defining different error messages for different Exceptions
     * thrown on business layer.
     * @author Administrator
     */
    public enum ApplicationErrorCode {
        /**
         * Constant representing a technical error, thrown when exception is
         * thrown by a DAO.
         */
        TE("Technical_Error"),
        /**
         * Constant representing an error if input param is null.
         */
        RS_B_PARAM_NULL("input param is null");
        private String message;

        // Enumeration Constructor
        private ApplicationErrorCode(String message) {
            this.message = message;
        }
    }

    // Enumeration Object
    private ApplicationErrorCode errorCode;

    /**
     * Exception Constructor 1 - overwritten, sets errCode (enum object).
     * @param errorCode an error code
     */
    public ApplicationException(ApplicationErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Exception Constructor 2 - overwritten, sets errorCode (enum object) and
     * exception cause.
     * @param errorCode an error code
     * @param cause Exception that threw the error
     */
    public ApplicationException(ApplicationErrorCode errorCode, Exception cause) {
        super(errorCode.message);
        this.errorCode = errorCode;
        this.initCause(cause);
    }

    /**
     * getter
     * 
     * @return error code
     */
    public ApplicationErrorCode getCode() {
        return errorCode;
    }

    /**
     * Returns specific error message, messages are defined in enumeration.
     * @return error message
     */
    public String getErrorMessage() {
        return errorCode.message;
    }
}
