/**
 * 
 */
package de.itemis.qimpress.showcase.crm_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.crm_simulator.be.domain.Customer;
import de.itemis.qimpress.showcase.crm_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.crm_simulator.be.filter.CustomerFilter;

/**
 * This interface is needed to query customers.
 * 
 * @author Claudius Haecker
 * @author braeuninger
 *
 */
public interface CustomerDao {

    /**
     * retrieves a List of customers that match given filter criteria.
     * @param filter the criteria
     * @return a list of Customers that match the criterions in the filter object 
     * @throws DaoException if database problems occur
     */
    public List<Customer> queryCustomers(CustomerFilter filter) throws DaoException;

}
