/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.workflow;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

import eu.qimpress.ide.checkers.jpfcheck.JPFCheckPlugin;

/**
 * JPFCheck counter example error status.
 * 
 * TODO implement clickable stack trace.
 * 
 * @author Michal Malohlava
 * @see IStatus
 *
 */
public class JPFCheckCIStatus extends MultiStatus {
	
	@SuppressWarnings("serial")
	static class CounterExampleFoundException extends Exception {
			
		public CounterExampleFoundException(StackTraceElement[] stackTrace) {
			setStackTrace(stackTrace);
		}
		
		@Override
		public String toString() {
			return "Counter example found:";
		}
	}

	public JPFCheckCIStatus(String message, StackTraceElement[] stackTrace) {		
		super(JPFCheckPlugin.PLUGIN_ID, IStatus.OK, message, (stackTrace != null ? new CounterExampleFoundException(stackTrace) : null));
		
		if (stackTrace != null) {
			for (StackTraceElement s : stackTrace) {
				add(new Status(IStatus.ERROR, JPFCheckPlugin.PLUGIN_ID, s.toString()));
			}
		}
	}	
}
