/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.ui.tabs;


import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewer;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory.SelectAlternativesEnum;
import eu.qimpress.ide.checkers.jpfcheck.ui.JPFCheckTabGroup;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.provider.StaticstructureItemProviderAdapterFactory;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;



/**
 * Tab needed to select component to be checked by JPF checker.
 * 
 * @author Michal Malohlava
 * @author Tomas Pop 
 */
public class SelectAlternativeTab extends AbstractLaunchConfigurationTab {

	private QAlternativesTreeViewer alternativeViewer;
	private CheckboxTableViewer componentList;
	protected Text compImplText;
	private Boolean isImplSelected = false;
	private ILaunchConfigurationTab jpfConfigTabReference;

	private IQAlternative selectedAlternative;
	private IQModel selectedModel;
	private ComponentType selectedComponent = null;

	
	private static String createTBPFilename(IQAlternative alternative, String src) {
        src = src.replaceAll("<", "_");
        src = src.replaceAll(">", "_");
        src = src.replaceAll(" ", "_");
        src = src.replaceAll("\\.", "_");
        return alternative.getAlternativeFolder().getFile(src + ".tbp").getProjectRelativePath().toOSString();
    }

	public void setJPFCheckerConfigTabReference(ILaunchConfigurationTab jpfConfigTabRef){
		jpfConfigTabReference = jpfConfigTabRef; 
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets
	 * .Composite)
	 */
	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);

		//initializeDialogUnits(parent);
		composite.setLayout(new GridLayout(4, false));

		setControl(composite);

		// Parent alternative label ...
		Label alternativeLabel = new Label(composite, SWT.NONE);
		alternativeLabel.setText("Alternative");
		GridDataFactory.generate(alternativeLabel, 1, 1);

		// Alternative tree viewer
		alternativeViewer = (QAlternativesTreeViewer) QAlternativesTreeViewerFactory.createTreeViewer(composite, SelectAlternativesEnum.NONE).getTreeViewer();

		alternativeViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {				
				componentList.setItemCount(0);
				IQAlternative alternative = alternativeViewer.getFirstSelectedAlternative();
				if (alternative != null) {					
					IQModel staticStructureModel = null;
					
					try {
						staticStructureModel = alternative.getModel(RepositoryModels.REPOSITORY_MODEL_EXT);
						if (staticStructureModel != null) {
							selectedModel = staticStructureModel;
							updateComponentList(staticStructureModel);							
						}
					} catch (RepositoryException e) {						
						e.printStackTrace();
					}					
				}
				
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});

		GridDataFactory.generate(alternativeViewer.getControl(), 3, 1);
		
		// Component selection ...
		Label componentLabel = new Label(composite, SWT.NONE);
		componentLabel.setText("Component");
		GridDataFactory.generate(componentLabel, 1, 20);
		
		componentList = CheckboxTableViewer.newCheckList(composite, SWT.BORDER);
		componentList.setLabelProvider(new AdapterFactoryLabelProvider(new StaticstructureItemProviderAdapterFactory()));		
		componentList.addCheckStateListener(new ICheckStateListener() {
			
			@Override
			public void checkStateChanged(CheckStateChangedEvent event) {
				Boolean isTBPSelected = false;
				
				if (event.getChecked() == false) {
					selectedComponent = null;
					isImplSelected = false;
					isTBPSelected = false;
				} else {
					componentList.setCheckedElements(new Object[] { event.getElement() });
					selectedComponent = (ComponentType) event.getElement();
					
					
					try {
						IQAlternative alternative = alternativeViewer.getFirstSelectedAlternative();
						/* load models to mine information about implementation file */
						alternative.getModel(RepositoryModels.REPOSITORY_MODEL_EXT);
						alternative.getModel(RepositoryModels.SOURCECODE_DECORATOR_EXTENSION);
						alternative.getModel(RepositoryModels.GAST_EXTENSION);
						IQModel sourceCodeDecoratorInstance 
							= alternative.getModel(RepositoryModels.SOURCECODE_DECORATOR_EXTENSION);
						
						
						SourceCodeDecoratorRepository sourceCodeRepo; 
						sourceCodeRepo = sourceCodeDecoratorInstance.getTopLevelEObject(SourceCodeDecoratorRepository.class);
						EList<FileLevelSourceCodeLink> codeLinks = sourceCodeRepo.getFileLevelSourceCodeLink();
						System.out.println();
					
						isImplSelected = false;
			            for (FileLevelSourceCodeLink codeLink : codeLinks) {
			                if (codeLink.getFile() == null) { 
			                		if (!isImplSelected) {
										compImplText.setText("Selected Component does not have associated a file");										
									}
			                    continue;
			                }
			                
			                ComponentType ctype = codeLink.getComponentType();
			                if (ctype.getId().equals(selectedComponent.getId())){
			                	// this is awfull, I know, but why the hell is the getPathName() implemented this way???
			                	//compImplText.setText(new Path(codeLink.getFile().getPathName()).toOSString().substring(5));
			                	
			                	try {
			                		IProject project = alternative.getRepository().getQProject().getProject();
				                	if (project.hasNature(JavaCore.NATURE_ID)) {
				                		IJavaProject jp = (IJavaProject) JavaCore.create(project);
				                		if (jp != null) {
				                			IPackageFragmentRoot[] pfrs = jp.getAllPackageFragmentRoots();
				                			IPath path = new Path(codeLink.getFile().getPathName().substring(5));
				                			IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
				                			path = path.makeRelativeTo(root);
				                			for (IPackageFragmentRoot pfr : pfrs) {
				                				if (pfr.getPath().isPrefixOf(path)) {
				                					String text = path.makeRelativeTo(pfr.getPath()).toString().replaceAll("/", "\\.");
				                					text = text.substring(0, text.length() - 5);
				                					if (!isImplSelected) {
				                						compImplText.setText(text);
				                					}
				                					else {
				                						compImplText.setText(compImplText.getText()+";"+text);
				                					}
				    			                	isImplSelected = true;
				                					break;
				                				}
				                			}
				                		}
			                	}
			                	}
			                	catch (CoreException e) {
			                		//null			                	
			                	}
			                	
			                	
			                	
			                	// this is again nasty, sorry for that
			                	if (!isTBPSelected) {
			                		((JPFCheckConfigTab)jpfConfigTabReference).setTBPFile(
			                			"/" + alternative.getRepository().getQProject().getProject().getName() + "/" + createTBPFilename(alternative,getSelectedComponent().getName()).replaceAll("\\\\", "/"));
			                		isTBPSelected = true;
			                	}
			                }
			            }
					} catch (RepositoryException e) {
						System.err.println("Cannot get the model");
						e.printStackTrace();					
					}
				}
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
					
		});
		GridDataFactory.generate(componentList.getControl(), 3, 20);
				
		/* Selection of configuration selection */
		Label compImplLabel = new Label(composite, SWT.NONE);
		compImplLabel.setText("Comp. impl.");
		compImplLabel.setToolTipText("Component implementation");
		GridDataFactory.generate(compImplLabel, 2, 1);
		
		compImplText = new Text(composite, SWT.SINGLE | SWT.BORDER);
		GridDataFactory.generate(compImplText, 1, 1);
		compImplText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});
		
		compImplText.setEditable(false);
	}
	
	protected boolean validatePage() {
		selectedAlternative = alternativeViewer.getFirstSelectedAlternative();
	
		
		if (getSelectedAlternative() == null) {
			setErrorMessage("An alternative has to be selected!");
			return false;
		}
				
		if (selectedComponent == null ) {
			setErrorMessage("A primitive component has to be selected!");
			return false;			
		}
		
		if (selectedComponent == null ) {
			setErrorMessage("A primitive component has to be selected!");
			return false;			
		}		
		
		if (!isImplSelected){
			setErrorMessage("Selected Component does not have associated source file!");
			return false;
		}

		
		return true;
	}

	@Override
	public String getName() {
		return "Select component";
	}

	public boolean isValid(ILaunchConfiguration launchConfig) {
		setErrorMessage(null);
		
		return validatePage();
	}

	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {						
			IQAlternative alternative = null;
			String attribute = configuration.getAttribute(JPFCheckTabGroup.JPFCHECK_ALTERNATIV_ID, (String) null);
			
			if (attribute != null) {
				IQElement element = QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(attribute);
				if ((element != null) && (element.getElementType().equals(ElementType.Q_ALTERNATIVE))) {
					alternative = (IQAlternative) element;
				}
	
				if (alternative != null) {
					alternativeViewer.setSelection(new StructuredSelection(alternative));				
				}
			}
			
			compImplText.setText(configuration.getAttribute(JPFCheckTabGroup.JPFCHECK_COMP_IMPL, ""));
			compImplText.setText("Select component...");
        	isImplSelected = false;

		} catch (CoreException e) {
		}

	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		selectedAlternative = alternativeViewer.getFirstSelectedAlternative();

		if (getSelectedAlternative() != null) {
			configuration.setAttribute(JPFCheckTabGroup.JPFCHECK_ALTERNATIV_ID, getSelectedAlternative().getInfo().getId());
		}
		
		if (getSelectedModel() != null) {
			configuration.setAttribute(JPFCheckTabGroup.JPFCHECK_INPUT_SAMM_REPOSITORY, getSelectedModel().getCorrespondingResource().getFullPath().toPortableString());			
		}
		
		if (getSelectedComponent() != null) {
			configuration.setAttribute(JPFCheckTabGroup.JPFCHECK_COMPONENT_ID, getSelectedComponent().getId());			
		}
		
		configuration.setAttribute(JPFCheckTabGroup.JPFCHECK_COMP_IMPL, compImplText.getText());
	}
	
	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
	}
	
	protected void updateComponentList(IQModel ssModel) {
		EObject topEO = ssModel.getTopLevelEObject();
				
		if (topEO instanceof Repository) {
			Repository repo = (Repository) topEO;
			EList<ComponentType> compTypes = repo.getComponenttype();
			
			for (ComponentType cType : compTypes) {
				if (cType instanceof PrimitiveComponent){
					componentList.add(cType);
					if (selectedComponent != null && cType.getId().equals(selectedComponent.getId())) {
						componentList.setChecked(selectedComponent, true);
					}
				}
				
			}
		} 
	}

	public IQModel getSelectedModel() {
		return selectedModel;
	}

	public ComponentType getSelectedComponent() {
		return selectedComponent;
	}

	public IQAlternative getSelectedAlternative() {
		return selectedAlternative;
	}
}

