/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.ui.tabs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.checkers.jpfcheck.ui.BrowseDialogsHelper;
import eu.qimpress.ide.checkers.jpfcheck.ui.JPFCheckTabGroup;

/**
 * Config tab for JPF checker.
 * 
 * @author Michal Malohlava
 * @author Tomas Pop 
 *
 */
public class JPFCheckConfigTab extends AbstractLaunchConfigurationTab {
		
	private static final String DEFAULT_ENV_EMPTY_SET = "org.ow2.dsrg.fm.tbpjava.envgen.EmptyValueSet";
	
	protected Text behavProtFilenameText;
	protected Text envValueSetsText;
		
	private ILaunchConfiguration conf;
	private SelectAlternativeTab selectAlternativeTab;

	public JPFCheckConfigTab(SelectAlternativeTab tab1) {
		this.selectAlternativeTab = tab1;
	}

	@Override
	public void createControl(Composite parent) {
		/* Root container config */
		Composite rootContainer = new Composite(parent, SWT.NULL);
		rootContainer.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		rootContainer.setLayout(new GridLayout(3, false));
		setControl(rootContainer);
		
		Button selectionButton = null;
		GridData data = null;
		
		/* Select behav. protocol file */
		Label behavProtFileLabel = new Label(rootContainer, SWT.NONE);
		behavProtFileLabel.setText("Behavior protocol:");
		behavProtFileLabel.setToolTipText("Select behavior protocol file - e.g., *.tbp");
		
		
		behavProtFilenameText = new Text(rootContainer, SWT.SINGLE | SWT.BORDER);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		behavProtFilenameText.setLayoutData(data);
		behavProtFilenameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});
		
		selectionButton = new Button(rootContainer, SWT.PUSH);
		selectionButton.setText("Browse");
		selectionButton.addSelectionListener(new SelectionAdapter() {
			
			public void widgetSelected(SelectionEvent e) {
				IFile selectedFile = BrowseDialogsHelper.browseForFile(getShell(), ResourcesPlugin.getWorkspace().getRoot(), "*.tbp");
				if (selectedFile != null) {
					behavProtFilenameText.setText(selectedFile.getFullPath().toPortableString());
					setDirty(true);
					updateLaunchConfigurationDialog();
				}
			}			
		});
		
		/* envvaluesets variable */
		Label envValueSetsLabel = new Label(rootContainer, SWT.NONE);
		envValueSetsLabel.setText("env.valuesets = ");
		envValueSetsLabel.setToolTipText("Setup class configuration environment parameters for JPF. E.g., env.valuesets=de.itemis.qimpress.showcase.crm_simulator.TestCRMManager");
		
		
		envValueSetsText = new Text(rootContainer, SWT.SINGLE | SWT.BORDER);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;		
		envValueSetsText.setLayoutData(data);
		envValueSetsText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setDirty(true);
				updateLaunchConfigurationDialog();
			}
		});

		selectionButton = new Button(rootContainer, SWT.PUSH);
		selectionButton.setText("Browse");
		selectionButton.addSelectionListener(new SelectionAdapter() {
		
			public void widgetSelected(SelectionEvent e) {
				IQAlternative selectedAlternative = selectAlternativeTab.getSelectedAlternative();
				if (selectedAlternative != null) {
					IProject project = selectedAlternative.getRepository().getQProject().getProject();
					IType selectedType = BrowseDialogsHelper.browseForClass(getShell(), new IJavaElement[] { JavaCore.create(project) }, "Test*" );
					if (selectedType != null) {
						envValueSetsText.setText(selectedType.getFullyQualifiedName());
						
						setDirty(true);
						updateLaunchConfigurationDialog();						
					}
				} else {
					MessageDialog.openInformation(getShell(), "Browse for type", "Alternative has to be selected before browsing");
				}
			}			
		});
		
				
	}
		
	@Override
	public String getName() {		
		return "Consistency checker configuration";
	}

	@Override
	public void initializeFrom(ILaunchConfiguration config) {
		try {
			conf = config;
			behavProtFilenameText.setText(config.getAttribute(JPFCheckTabGroup.JPFCHECK_BEHAV_PROT_FILE, ""));
			envValueSetsText.setText(config.getAttribute(JPFCheckTabGroup.JPFCHECK_ENV_VALUESETS, DEFAULT_ENV_EMPTY_SET));		
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	public void setTBPFile(String tbpFilePath){
		
		// WARNING: THIS DOES NOT WORK AS EXPECTED!! 
		// behavProtFilenameText.setText(tbpFilePath);
		
		((ILaunchConfigurationWorkingCopy) conf).setAttribute(JPFCheckTabGroup.JPFCHECK_BEHAV_PROT_FILE, tbpFilePath);
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy conf) {
		conf.setAttribute(JPFCheckTabGroup.JPFCHECK_BEHAV_PROT_FILE, this.behavProtFilenameText.getText());
		conf.setAttribute(JPFCheckTabGroup.JPFCHECK_ENV_VALUESETS, this.envValueSetsText.getText());
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {				
	}
	
	
	protected boolean validatePage() {
		
		IQAlternative alt= selectAlternativeTab.getSelectedAlternative();
		Path path = new Path(behavProtFilenameText.getText());
		if (alt == null) {
			return false;
		}
		else if (!path.isValidPath(path.toString()))
			return false;
		else {
			//java.io.File f = new java.io.File(behavProtFilenameText.getText());
			if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) {
				setErrorMessage("Behavior Protocol File is not selected or not present in the filesystem");
				return false;
			}
			
			return true;
		}
	}	
	
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		setErrorMessage(null);
		return validatePage();
	}

}
