/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.ui;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;

import eu.qimpress.ide.checkers.jpfcheck.ui.tabs.JPFCheckConfigTab;
import eu.qimpress.ide.checkers.jpfcheck.ui.tabs.SelectAlternativeTab;

/**
 * JPF checker run configuration
 * 
 * @author Michal Malohlava
 *
 */
public class JPFCheckTabGroup extends AbstractLaunchConfigurationTabGroup {
	
	public static final String JPFCHECK_ALTERNATIV_ID = "eu.qimpress.ide.checkers.jpfcheck.alternative.id";	
	public static final String JPFCHECK_INPUT_SAMM_REPOSITORY = "eu.qimpress.ide.checkers.jpfcheck.input.repository";
	public static final String JPFCHECK_COMPONENT_ID = "eu.qimpress.ide.checkers.jpfcheck.component.id";;
	public static final String JPFCHECK_COMP_IMPL = "eu.qimpress.ide.checkers.jpfcheck.comp.impl";
	public static final String JPFCHECK_BEHAV_PROT_FILE = "eu.qimpress.ide.checkers.jpfcheck.behavprot.file";	
	public static final String JPFCHECK_ENV_VALUESETS = "eu.qimpress.ide.checkers.jpfcheck.env.valuesets";
		

	@Override
	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		SelectAlternativeTab tab1 = new SelectAlternativeTab();
		ILaunchConfigurationTab tab2 = new JPFCheckConfigTab(tab1);
		tab1.setJPFCheckerConfigTabReference(tab2);
		
		ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[] {
				tab1, tab2				
		};
		
		setTabs(tabs);		
	}
}
