/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.ui;

import java.io.File;
import java.util.ArrayList;

import org.apache.log4j.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;

import de.uka.ipd.sdq.workflow.Blackboard;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.ide.checkers.jpfcheck.workflow.JPFCheckJob;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Repository;

/**
 * @author Michal Malohlava
 *
 */
public class JPFCheckConfigurationDelegate 
extends AbstractWorkflowBasedLaunchConfigurationDelegate<JPFCheckConfiguration, UIBasedWorkflow<Blackboard<String>>> {
	
	@Override
	protected IJob createWorkflowJob(JPFCheckConfiguration config,
			ILaunch launch) throws CoreException {
		
		JPFCheckJob job = new JPFCheckJob(config);
				
		return job;		
	}

	@Override
	protected JPFCheckConfiguration deriveConfiguration(
			ILaunchConfiguration conf, String mode)
			throws CoreException {
		
		JPFCheckConfiguration jpfConf = new JPFCheckConfiguration();
		
		try {
			jpfConf.alternative = (IQAlternative) QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(conf.getAttribute(JPFCheckTabGroup.JPFCHECK_ALTERNATIV_ID, ""));
			jpfConf.model = jpfConf.alternative.getModel(RepositoryModels.REPOSITORY_MODEL_EXT);
			
			String ctID = conf.getAttribute(JPFCheckTabGroup.JPFCHECK_COMPONENT_ID, (String) null);		
			Repository repoEO = (Repository) jpfConf.model.getTopLevelEObject();
			EList<ComponentType> ctList = repoEO.getComponenttype();
			for (ComponentType cType: ctList) {
				if (cType.getId().equals(ctID)) {
					jpfConf.componentType = cType;
					break;
				}
			}
			jpfConf.componentImpl = conf.getAttribute(JPFCheckTabGroup.JPFCHECK_COMP_IMPL, (String) null);
			
			IFile protocolFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString(conf.getAttribute(JPFCheckTabGroup.JPFCHECK_BEHAV_PROT_FILE, (String) null) ));
			jpfConf.protocolFile = new File(protocolFile.getLocationURI());  
			
			jpfConf.additionalParameters.put("env.valuesets", conf.getAttribute(JPFCheckTabGroup.JPFCHECK_ENV_VALUESETS, (String) null));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return jpfConf;		
	}
		
	@Override
	protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel)
			throws CoreException {
		
		ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();

		loggerList.add(setupLogger("de.uka.ipd.sdq.workflow", logLevel,	SHORT_LOG_PATTERN));
		loggerList.add(setupLogger("eu.qimpress.ide.checkers.jpfcheck", logLevel, SHORT_LOG_PATTERN));
		
		return loggerList;	
	}	
}
