/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.checkers.jpfcheck.workflow.JPFCheckJob;
import eu.qimpress.samm.staticstructure.ComponentType;

/**
 * Workflow configuration for JPFCheck Job
 *
 * @author Michal Malohlava
 * @see JPFCheckJob
 *
 */
public class JPFCheckConfiguration extends AbstractWorkflowBasedRunConfiguration {
	
	IQAlternative alternative;
	
	IQModel model;
	
	ComponentType componentType;
	
	String componentImpl;
	
	File protocolFile;
	
	/* @deprecated - configuration file */
	File configurationFile;
		
	Map<String, String> additionalParameters = new HashMap<String, String>();
	
	public String getErrorMessage() {
		if (componentType == null) {
			return "Missing component type";
		}
		
		if (componentImpl == null || "".equals(componentImpl)) {
			return "Missing component implementation class";
		}
		
		if (protocolFile == null || !protocolFile.exists() || !protocolFile.canRead()) {
			return "Missing protocol file or it is not accessible";
		}
		
		return null;
	}

	public void setDefaults() {		
	}

	public IQAlternative getAlternative() {
		return alternative;
	}

	public void setAlternative(IQAlternative alternative) {
		this.alternative = alternative;
	}

	public IQModel getModel() {
		return model;
	}

	public void setModel(IQModel model) {
		this.model = model;
	}

	public ComponentType getComponentType() {
		return componentType;
	}

	public void setComponentType(ComponentType componentType) {
		this.componentType = componentType;
	}

	public String getComponentImpl() {
		return componentImpl;
	}

	public void setComponentImpl(String componentImpl) {
		this.componentImpl = componentImpl;
	}

	public File getProtocolFile() {
		return protocolFile;
	}

	public void setProtocolFile(File protocolFile) {
		this.protocolFile = protocolFile;
	}

	public File getConfigurationFile() {
		return configurationFile;
	}

	public void setConfigurationFile(File configurationFile) {
		this.configurationFile = configurationFile;
	}

	public Map<String, String> getAdditionalParameters() {
		return additionalParameters;
	}

	public void setAdditionalParameters(Map<String, String> additionalParameters) {
		this.additionalParameters = additionalParameters;
	}
	
	
	public IProject getProject() {
		if (this.alternative != null) {
			IProject project = this.alternative.getRepository().getQProject().getProject();
			
			return project;
		}
		
		return null;
	}
	
	public IJavaProject getJavaProject() {
		try {
			if (this.alternative != null) {
				IProject project = this.alternative.getRepository().getQProject().getProject();
				if (project.hasNature(JavaCore.NATURE_ID) ) {
					return JavaCore.create(project);
				}
			}
		} catch (CoreException e) { e.printStackTrace(); }
		
		return null;
	}	
}
