/**
 * 
 */
package eu.qimpress.ide.checkers.jpfcheck.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

/**
 * Helper for preparing different types of browse dialogs.
 * 
 * @author Michal Malohlava
 *
 */
public class BrowseDialogsHelper {
	
	/**
	 * Open "Browse resources" dialog for selecting a file.
	 * 
	 * @param shell UI shell
	 * @param container container containing resources
	 * @param initialPattern initial search patter
	 * 
	 * @return selected file.
	 */
	public static final IFile browseForFile(Shell shell, IContainer container, String initialPattern) {
		FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(shell, false, container, IResource.FILE);
		
		dialog.setInitialPattern(initialPattern);
		dialog.open();
				
		if (dialog.getReturnCode() == Window.OK) {
			return (IFile) dialog.getResult()[0];			
		}
		
		return null;
	}

	/**
	 * 
	 * @param elements
	 * @param initialPattern
	 * @return
	 */
	public static final IType browseForClass(Shell shell, IJavaElement[] elements, String initialPattern) {
		try {
			IJavaSearchScope scope= SearchEngine.createJavaSearchScope(elements);
			SelectionDialog dialog= JavaUI.createTypeDialog(shell, PlatformUI.getWorkbench().getProgressService(), scope,
					IJavaElementSearchConstants.CONSIDER_CLASSES, false, initialPattern, null); 
			dialog.setTitle("Select java class");
			dialog.setMessage("Select Java class");
			dialog.open();
			if (dialog.getReturnCode() == Window.OK) {
				IType type= (IType)dialog.getResult()[0];
								
				return type;
			}
		} catch (JavaModelException ex) {
			ex.printStackTrace();
		}
		
		return null;
	}
	
}
