package eu.qimpress.ide.backbone.project.repository.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.qosannotation.Annotation;
import eu.qimpress.samm.qosannotation.QosAnnotations;

public class OpenEdificeEditorAction implements IObjectActionDelegate {
	
	private static final String EDITOR_ID = "eu.qimpress.ide.editors.text.Edifice";  
	
	private Shell shell = null;	
	private NamedEntity entity = null;

	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.shell = targetPart.getSite().getShell();		
	}

	@Override
	public void run(IAction action) {		
		IConcreteSyntaxFile lazyDSLFile = null;
		try {
			lazyDSLFile = (IConcreteSyntaxFile) Platform.getAdapterManager().getAdapter(entity, IConcreteSyntaxFile.class);

			// perform transformation
			if (lazyDSLFile != null) {
				lazyDSLFile.generate();
				
				lazyDSLFile.openInEditor(EDITOR_ID);				
			}
		} catch (Throwable e) {			
			e.printStackTrace();
			if (lazyDSLFile != null) {
				lazyDSLFile.dispose();
			}
			MessageDialog.openError(shell, "Error occured during opening editor", "Cannot open editor for the entity " + entity.getName());
		} 
	}	
	
	protected boolean deniedNamedEntity(NamedEntity namedEntity) {
		if (namedEntity instanceof QosAnnotations || namedEntity instanceof Annotation) {
			return true;
		}
		
		return false;
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection != null && selection instanceof IStructuredSelection) {
			IStructuredSelection sselection = (IStructuredSelection) selection;
			
			if (!sselection.isEmpty()) {
				entity = (NamedEntity) sselection.getFirstElement();				
				if (deniedNamedEntity(entity)) {
					action.setEnabled(false);					
				} else {
					action.setEnabled(true);
				}
			} 
		}
		
	}

	
}
