/**
 * 
 */
package eu.qimpress.ide.backbone.project.adapters;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.ui.PartInitException;

import eu.qimpress.ide.backbone.project.Activator;
import eu.qimpress.samm.core.NamedEntity;

/**
 * Implementation of {@link IConcreteSyntaxFile} interface based on MWE transformation workflow.
 * 
 * Transforms given NamedEntity into a concrete file stored in a project's hidden directory. 
 * 
 * @author Michal Malohlava
 * 
 * @deprecated use Xtext-based serialization {@link XtextResourceBasedConcreteSyntaxFile}
 *
 */
public class MWEBasedConcreteSyntaxFile implements IConcreteSyntaxFile {
	
	/** Directory with model templates */
	public static final String MODEL_TEMPLATES_DIR = "/workflow";
	
	private NamedEntity namedEntity;
	private IProject project;
	private IFile file;
		
	public MWEBasedConcreteSyntaxFile(NamedEntity namedEntity, IFile file) {		
		this.namedEntity = namedEntity;
		this.project = file.getProject();
		this.file = file;
	}

	/* (non-Javadoc)
	 * @see eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile#getFile()
	 */
	@Override
	public IFile generate() {
		IFile result = null; 
		
		try {
			doGenerate();
			result = this.file;
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return result;
	}

	protected void doGenerate() throws URISyntaxException, IOException {
		// create temporary DSL file via calling MWE workflow
		URL mweFileURL = FileLocator.toFileURL(Activator.getDefault().getBundle().getEntry(MODEL_TEMPLATES_DIR+ "/EdificeGenerator.mwe"));
		String mweFile = mweFileURL.getFile();
		
		Map<String, String> properties = new HashMap<String, String>(1);					
		Map<String, NamedEntity> slotContents = Collections.singletonMap("model", namedEntity);
		
		properties.put("outputFolder", URIUtil.toFile(file.getParent().getLocationURI()).getAbsolutePath());
		
		new WorkflowRunner().run(mweFile, null, properties, slotContents);
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@Override
	public Object getAdapter(Class adapter) {
		
		if (adapter.equals(NamedEntity.class)) {
			return namedEntity;
		} else if (adapter.equals(EObject.class)) {
			return namedEntity;
		} else if (adapter.equals(IProject.class)) {
			return project;
		}
		
		return null;
	}
	
	@Override
	public void dispose() {
		// TODO Auto-generated method stub		
	}

	@Override
	public Resource getConcreteResource() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Resource getOriginalResource() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IFile getOutputFile() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void openInEditor(String editorId) throws PartInitException {
		// TODO Auto-generated method stub
		
	}

}
