/**
 * 
 */
package eu.qimpress.ide.backbone.project.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.samm.core.NamedEntity;

/**
 * Adapter factory for converting NamedEntity to a file stored on the filesystem in the local storage.
 * 
 * @author Michal Malohlava
 * @deprecated use Xtext serialization 
 * @see {@link XtextResourceBasedConcreteSyntaxFile}
 *
 */
public class MWEBasedConcreteSyntaxAdapterFactory extends AbstractConcreteSyntaxAdapterFactory {
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object, java.lang.Class)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType.equals(IConcreteSyntaxFile.class)) {
			if (adaptableObject instanceof NamedEntity) {
				NamedEntity entity = (NamedEntity) adaptableObject;
				IProject project = QImpressCore.getProject(entity.eResource().getURI());				
				
				try {										
					// create file on the file system
					String fileName = entity.getName() + "_" + entity.getId() + ".edifice";
					
					IFile outputFile = getOutputFile(fileName, project);
										
					IConcreteSyntaxFile result = new MWEBasedConcreteSyntaxFile(entity, outputFile);
					
					return result;
				} catch (CoreException e) {					
					e.printStackTrace();
				}
			}			
		}
		
		return null;
	}
}
