package eu.qimpress.ide.backbone.project.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.PartInitException;

/**
 * Abstraction of a file containing concrete syntax of model element.
 * 
 * It encapsulates mapping between model resource and xtext resource.
 * 
 * @author Michal Malohlava
 *
 */
public interface IConcreteSyntaxFile extends IAdaptable {
		
	/**
	 * Generate the file with concrete syntax and returns a reference on the generated file.
	 * 
	 * The implementation can just return phantom reference to a file or directly generated file.
	 * 
	 * @return file in the workspace. 
	 * @throws Exception if some error occur
	 */
	IFile generate() throws Exception;
	
	/**
	 * Return reference to output file.
	 * 
	 * @return always an output file never re-generated output.
	 */
	IFile getOutputFile();
	
	
	/**
	 * Dispose given concrete syntax file. E.g., the method unregisters listeners, dispose 
	 * temporary file stored in the workspace, ... 
	 */
	void dispose();
	
	
	/**
	 * Return original ecore resource.
	 * 
	 * @return original ecore resource.
	 */
	Resource getOriginalResource();
	
	/**
	 * Return resource with concrete syntax (xtext).
	 * 
	 * @return resource containing concrete syntax.
	 */
	Resource getConcreteResource();
	
	/**
	 * Open editor for the given file.
	 * 
	 * @param editorId id of editor to be opened  
	 * 
	 * @throws PartInitException if the editor creation fails
	 */
	void openInEditor(String editorId) throws PartInitException;
}
