/**
 * 
 */
package eu.qimpress.ide.backbone.project.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**
 * Shared core for factories generating adapting model entities to project files.
 * 
 * @author Michal Malohlava
 *
 */
public abstract class AbstractConcreteSyntaxAdapterFactory implements IAdapterFactory {
	
	private static final Class[] SUPPORTED_ADAPTERS = new Class[] { IConcreteSyntaxFile.class };
	
	public static final String GENERATED_FOLDER = ".generated";
	
	protected IFolder checkGeneratedDirectory(IProject project) throws CoreException {
		IPath generatedPath = new Path(GENERATED_FOLDER);
		
		IFolder result = project.getFolder(generatedPath);
		if (!result.exists()) {
			result.create(true, true, null);			
		}
		
		return result;		
	}
	
	/**
	 * Returns file for storing concrete syntax.
	 * 
	 * @param project
	 * @return
	 * @throws CoreException 
	 */
	protected IFile getOutputFile(String fileName, IProject project) throws CoreException {
		IFolder outputFolder = checkGeneratedDirectory(project);
		
		IFile outputFile = outputFolder.getFile(fileName);
		
		return outputFile;
	}		
	
	@Override
	public Class[] getAdapterList() {
		return SUPPORTED_ADAPTERS;
	}

}
