/**
 * 
 */
package eu.qimpress.ide.backbone.core.utils;

import java.util.Arrays;

import org.apache.log4j.Logger;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.samm.usagemodel.UsageModel;
import eu.qimpress.samm.usagemodel.UsageRepository;

/**
 * Simple functions to operate with SAMM models.
 * 
 * @author Michal Malohlava
 *
 */
public class SAMMModelsUtils {
	
	private static final Logger logger = Logger.getLogger(SAMMModelsUtils.class);
	
	public static enum EnumModelLookup {
		ONLY_LOCAL  (1) ,
		ONLY_COMMON (2) , /* aka global */
		LOCAL_AND_COMMON  (3);
		
		private int value;
		
		private EnumModelLookup(int i) {
			this.value = i;
		}
		
		public boolean support(EnumModelLookup lookup) {
			boolean res = (this.value & lookup.value) != 0;
			return 	res;		
		}
	}
	
	public static UsageModel[] getUsageModels(IQAlternative alternative, EnumModelLookup lookup) throws RepositoryException {
		UsageModel[] result = null;
		
		if (lookup.support(EnumModelLookup.ONLY_LOCAL)) {
			result = getUsageModels(alternative);  
		}
		
		if (lookup.support(EnumModelLookup.ONLY_COMMON)) {
			IQRepository qRepo = alternative.getRepository();
			UsageModel[] commonResult = getUsageModels(qRepo.getGlobalAlternative());
			if (result != null) {
				int localResultLen = result.length;
				result = Arrays.copyOf(result, result.length + commonResult.length);
				for(int i = 0; i < commonResult.length; i++) result[localResultLen + i] = commonResult[i];				
			} else {
				result = commonResult;				
			}
		}
		
		return result;
	}
	
	/**
	 * Returns usage models stored only in a given alternative.
	 *  
	 * @param alternative
	 * @return an array of usage models, never returns null
	 * @throws RepositoryException
	 */
	public static UsageModel[] getUsageModels(IQAlternative alternative) throws RepositoryException {
		IQModel model = alternative.getModel(RepositoryModels.USAGE_MODEL_EXT);
		
		Object usageRepositoryObject = model.getTopLevelEObject(UsageRepository.class);
		
		
		
		if (usageRepositoryObject != null && usageRepositoryObject instanceof UsageRepository) {
			
			UsageRepository usageRepository = (UsageRepository) usageRepositoryObject;
			if (usageRepository.getUsageModels().size() > 0) 
				return usageRepository.getUsageModels().toArray(new UsageModel[]{});
			else
				return new UsageModel[]{};
		} else {							
			logger.warn("No usage repository or corrupted usage repository in alternative: " + alternative);
			return new UsageModel[]{};			
		}
		
	}
}
