/**
 * 
 */
package eu.qimpress.ide.backbone.core.operations;

import java.lang.reflect.InvocationTargetException;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

import eu.qimpress.ide.backbone.core.internal.model.QProjectImpl;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.resultmodel.ResultModelFactory;
import eu.qimpress.resultmodel.ResultRepository;

/**
 * Operation to initialize Q-ImPrESS project.
 * 
 * FIXME move this into IQController for {@link QProjectImpl}.
 * 
 * @author Michal Malohlava
 * @author Viliam Simko
 */
public class InitializeQImpressProjectOperation extends WorkspaceModifyOperation {
	
	private static final Logger logger = Logger.getLogger(InitializeQImpressProjectOperation.class);
	
	private IProject project;
	
	public InitializeQImpressProjectOperation(IProject project) {
		// setup scheduling rule
//		super(project);
		this.project = project;
	}

	@Override
	protected void execute(IProgressMonitor monitor) throws CoreException,
			InvocationTargetException, InterruptedException {
		try {
			// create default alternative and result model..
			createCommonInfrastructure(project);
			
		} catch (Exception e) {
			logger.error("Cannot setup Q-ImPrESS nature for project " + project, e);
			
			throw new InvocationTargetException(e);
		} finally {
			monitor.done();
		}
	}
	
	/**
	 * Creates common infrastructure in new project (global alternative, default result repository...)
	 * 
	 * @param qProject New project where new infrastructure should be created.
	 * @throws RepositoryException 
	 */
	private void createCommonInfrastructure(IProject project) throws RepositoryException {		
		// init repository by getting Q-I project repository to avoid getting exception during refresh action of workspace
		IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);				
		IQRepository qRepository = qProject.getRepository(); // this cause creation of the repository
		IQWorkspaceController repositoryController = (IQWorkspaceController) qRepository.getAdapter(IQWorkspaceController.class);
		if (repositoryController != null) {
			repositoryController.init(false, true);
		}
		
		// check if the alternatives exist then suppress their creation
		boolean foundGlobalAlternative = false;
		boolean foundOtherAlternative = false;
		
		if (qRepository.listTopLevelAlternatives().length > 0) {
			foundOtherAlternative = true;
			logger.info("There is already an alternative present in the project that can be used as a main alternative");
		}
		
		if (qRepository.getAlternative(IQRepository.GLOBAL_ALTERNATIVE_ID) != null) {
			foundGlobalAlternative = true;
			logger.info("There is already an alternative present in the project that can be used as a main alternative");						
		}
		
		// create main alternative if there are no other alternatives (except the global)
		if( ! foundOtherAlternative ) {
			IQAlternative defaultAlternative = qRepository.createAlternative(IQRepository.MAIN_ALTERNATIVE_NAME);
			// set is as default
			qRepository.setDefaultAlternative(defaultAlternative);
		}
		
		// create the global alternative on if it does not exist yet 
		if( ! foundGlobalAlternative)
			qRepository.createAlternative(IQRepository.GLOBAL_ALTERNATIVE_NAME, IQRepository.GLOBAL_ALTERNATIVE_ID);

		
		// create new result repository 
		IQModel resultModel = qRepository.getResultModel();
		resultModel.getTopLevelEObject(ResultRepository.class, ResultModelFactory.eINSTANCE.getResultModelPackage().getResultRepository());
		resultModel.save();	
	}
}
