/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;


/**
 * Control interface performing workspace operations.
 * 
 * @author Michal Malohlava
 *
 */
public interface IQWorkspaceController {
	
	/**
	 * Initialize given element. 
	 * 
	 * That means creating of workspace resource (folder, file), reading from database.
	 * 
	 * @param fork if the work should be done in separated job
	 * @param waitForFinish block or not to block
	 * 
	 * @return job which is performing initialization or null if waitforFinish == false && fork == true
	 */
	Job init(boolean fork, boolean waitForFinish) throws InitializationException;
	
	/**
	 * Returns workspace operation performing initialization.
	 * 
	 * @see WorkspaceModifyOperation
	 * 
	 * @return workspace operation
	 */
	WorkspaceModifyOperation getInitWSOperation();
}
