package eu.qimpress.ide.backbone.core.model;

import org.eclipse.core.resources.IProject;


/**
 * Project specific repository provider.
 * 
 * @author Petr Hnetynka
 * @author Michal Malohlava
 * 
 */
public interface IQProject extends IQElement, IParent {

	/**
	 * Get associated workspace project.
	 * 
	 * @return associated workspace project or null if the project is
	 *         not-accessible (e.g. closed)
	 */
	IProject getProject();

	/**
	 * Get default repository.
	 * 
	 * @return the default repository
	 * @throws RepositoryException something bad happened 
	 */
	IQRepository getRepository() throws RepositoryException;
}
