package eu.qimpress.ide.backbone.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * Model stored in the repository.
 * 
 * @author Petr Hnetynka
 * @author Michal Malohlava
 */
public interface IQModel extends IQElement {
	
	/**
	 * Returns full model name.
	 * 
	 * @return model name
	 */
	String getName();
	
	/**
	 * Return model type
	 * 
	 * @return model type, e.g., samm_repository. 
	 */
	String getType();

	/**
	 * Gets input stream.
	 * 
	 * @return input stream
	 */
	InputStream getInputStream() throws IOException;
	
	/**
	 * Gets currently attached alternative
	 * 
	 * @return alternative
	 */
	IQAlternative getAlternative();

	/**
	 * Gets output stream.
	 * 
	 * @return output stream
	 */
	OutputStream getOutputStream() throws IOException;
	
	/**
	 * Get top-level EObject of underlying model.
	 * 
	 * @return EObject
	 */
	EObject getTopLevelEObject();
	
	/**
	 * Returns a reference to the top-level EObject contained in the model.
	 * 
	 * @param clazz type of top-level object
	 * @return top-level object or null if the associated resource is empty
	 */
	<T extends EObject> T getTopLevelEObject(Class<T> clazz);
	
	/**
	 * Return a reference to the top-level EObject included in the model. 
	 * If the model is empty it creates appropriate top-level object.
	 * 
	 * @param clazz type of top-level object
	 * @param eClazz emf type of top-level object to create
	 * 
	 * @return always return instance of top-level object. If the model was empty and new top-level object was created, then it needs explicit save.
	 */
	<T extends EObject> T getTopLevelEObject(Class<T> clazz, EClass eClazz);
	
	/** Deletes the model.
	 * 
	 * @throws RepositoryException 
	 */
	void delete() throws RepositoryException;
	

	/**
	 * Save model.
	 * 
	 * Try to save underlying EMF resource. Does not check if the resource was modified.
	 * 
	 * @throws RepositoryException if resource does not exist or an error occurs during saving 
	 */
	void save() throws RepositoryException;
}
