/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;

import org.eclipse.core.runtime.jobs.Job;

/**
 * Model elements initialization/modification interface.
 * 
 * If the element support this interface it is accessible by getAdaptor(IQInitializer.class) method call 
 * @author Michal Malohlava
 *
 */
public interface IQInitializer {
	
	/**
	 * Returns true if the model element is fully initialized.
	 * 
	 * @return
	 */
	boolean isReady();
	
	/**
	 * Returns true if the element needs initialization. 
	 * 
	 * @see IQWorkspaceController
	 * @return
	 */
	boolean needsInitialization();
	
	
	/**
	 * Returns a job responsible for initialization or modification.
	 *  
	 * @return
	 */
	Job getWorkingJob();
}
