package eu.qimpress.ide.backbone.core.model;

public interface IQGlobalModelAccess {
	
	/**
	 * Returns the global alternative which is always present in a project.
	 * 
	 * @throws RepositoryException
	 */
	IQAlternative getGlobalAlternative() throws RepositoryException;
	
	
	
	/**
	 * Return a global (or so called common) model. 
	 * 
	 * @param modelType type of model which is required - see {@link RepositoryModels}
	 * @return model of the specified type
	 * @throws RepositoryException if the global alternative cannot be obtained 
	 */
	IQModel getGlobalModel(String modelType) throws RepositoryException;

}
