package eu.qimpress.ide.backbone.core.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

/**
 * 
 * @author Michal Malohlava
 * 
 */
public interface IQAlternative extends IQElement, IParent, Iterable<IQModel> {

	/**
	 * Returns alternative info.
	 * 
	 * @return alternative information
	 */
	IQAlternativeInfo getInfo();

	/**
	 * Get repository of alternatives
	 */
	IQRepository getRepository();

	/**
	 * Returns static structure model.
	 * 
	 * @return static structure model
	 */
	IQModel getStaticStructureModel() throws RepositoryException;

	// TODO add get methods for other known parts of SAMM

	/**
	 * Returns a required model.
	 * 
	 * If the model does not exist, new model is created.
	 * 
	 * @param type
	 *            type of the model
	 * @return model of the given type
	 */
	IQModel getModel(String type) throws RepositoryException;

	/**
	 * Returns an iterator over existing models.
	 * 
	 * @return an iterator over existing models
	 */
	java.util.Iterator<IQModel> iterator();

	/**
	 * Get all models in the repository.
	 * 
	 * @return array of models
	 */
	IQModel[] getModels();
	
	/**
	 * 
	 * @param refreshModelCache 
	 * @return list of IQModels from the repository
	 * 
	 * @see IQAlternative#getModels(boolean)
	 */
	IQModel[] getModels(boolean refreshModelCache);

	/**
	 * Tests whether the alternative is top level (with no parent alternative).
	 * 
	 * @return <code>true</code> if the alternative has no parent
	 */
	boolean isTopLevel();
	
	/** Deletes a model with the given name.
  	  * 
  	  * @throws RepositoryException 
	  */
	void deleteModel(String model) throws RepositoryException;
	
	/**
	 * Store given newly created object of specified type into a specified file.
	 * 
	 * @param eo EObject to store
	 * @param filename file name of resulting model file (without extension)
	 * @param modelType type of model - denotes an extension for file - see {@link RepositoryModels}
	 * @return model element representing given model
	 * 
	 * @throws RepositoryException
	 */
	IQModel storeEObject(EObject eo, String filename, String modelType) throws RepositoryException;
	
	/**
	 * Store given newly created objects of specified types into specified files.
	 * 
	 * Note that when storing the objects, order is important. Targets of references
	 * must be stored before references themselves, otherwise the references in the
	 * file will be invalid.
	 * 
	 * @param eos EObjects to store
	 * @param filenames file names of resulting model file (without extension)
	 * @param modelTypes types of model - denotes an extension for file - see {@link RepositoryModels}
	 * @return models element representing save model
	 * 
	 * @throws RepositoryException
	 */
	IQModel[] storeEObject(EObject[] eos, String[] filenames, String[] modelTypes) throws RepositoryException;

	/* === */

	/**
	 * Returns alternative folder
	 */
	IFolder getAlternativeFolder();
	
	/**
	 * Returns folder for temporary files.
	 * 
	 * @return folder for temporary files.
	 * @throws CoreException in case temporary folder could not be created.
	 */
	IFolder getTemporaryFolder() throws CoreException;
}
