/**
 * 
 */
package eu.qimpress.ide.backbone.core.internal.model;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.model.IWorkbenchAdapter;

import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * Q-ImPrESS project abstraction. 
 * It stores repository of model alternatives.
 * 
 * @author Michal Malohlava
 *
 */
public class QProjectImpl extends QElement implements IQProject {
	
	private IProject project;
	
	private IQRepository defaultRepository;
	private Map<IFolder, IQRepository> otherRepositories = new HashMap<IFolder, IQRepository>();

	public QProjectImpl(IProject project, IQApplicationModel qApplicationModel) {
		super(qApplicationModel);
		
		this.project = project;
	}

	@Override
	public IProject getProject() {		
		return this.project;
	}	
	
	@Override
	public IResource getCorrespondingResource() {		
		return this.project;
	}

	@Override
	public ElementType getElementType() {
		return ElementType.Q_PROJECT;
	}
	
	@Override
	public IQElement[] getChildren() {		
		return new IQElement[] { this.defaultRepository };
	}
	

	@Override
	public synchronized IQRepository getRepository() throws RepositoryException {
		
		if (this.defaultRepository == null) {
			final IFolder defaultRepoFolder = this.project.getFolder(QCachedDirectoryRepositoryImpl.DEFAULT_REPOSITORY_LOCATION);
			
			IQRepository qRepository = new QCachedDirectoryRepositoryImpl(this, defaultRepoFolder);
			/* repository is initialized asynchroniosly by a separeted job */			
			this.defaultRepository = qRepository;			
		}
		
		return this.defaultRepository;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		if (IWorkbenchAdapter.class.equals(adapter)) {
			return this.project.getAdapter(adapter);
		}
		return super.getAdapter(adapter);
	}
}
