/**
 * 
 */
package eu.qimpress.ide.backbone.core.internal.model;

import java.lang.reflect.InvocationTargetException;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.undo.CreateFolderOperation;

import eu.qimpress.ide.backbone.core.model.IQInitializer;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * Q-ImPrESS alternative repository controller.
 *
 * @author Michal Malohlava
 *
 */
public class QCachedDirectoryRepositoryController extends AbstractQController<QCachedDirectoryRepositoryImpl> implements IQInitializer {
	
	private static final Logger logger = Logger.getLogger(QCachedDirectoryRepositoryImpl.class);
	
	private boolean isReady = false;
	private Job workingJob = null;
	
	public QCachedDirectoryRepositoryController(QCachedDirectoryRepositoryImpl repo) {
		super(repo);				
	}
		
	@Override
	protected void doInit(IProgressMonitor monitor) throws CoreException,
			InvocationTargetException, InterruptedException {
		WorkspaceModifyOperation op = getInitWSOperation();
		op.run(monitor);		
	}
	
	@Override
	public WorkspaceModifyOperation getInitWSOperation() {
		return new InitializeRepositoryOperation();
	}
	
	private class InitializeRepositoryOperation extends WorkspaceModifyOperation {
		
		public InitializeRepositoryOperation() {
			super(element.getCorrespondingResource().getParent());
		}		

		@Override
		protected void execute(IProgressMonitor monitor) throws CoreException,
				InvocationTargetException, InterruptedException {
			try { 
				monitor.beginTask("", 2);			
			
				IFolder repositoryFolder = element.getRepositoryFolder();	
				repositoryFolder.refreshLocal(0, new SubProgressMonitor(monitor, 1));
				if (!repositoryFolder.exists() && !repositoryFolder.isLinked(IResource.CHECK_ANCESTORS)) {
					CreateFolderOperation op1 = new CreateFolderOperation(repositoryFolder, null, "Create repository folder");
					try {
						IStatus status = op1.execute(new SubProgressMonitor(monitor, 1), null);
						if (status.matches(IStatus.ERROR)) {
							throw new InvocationTargetException(status.getException());
						}
					} catch (ExecutionException e) {
						if (!repositoryFolder.exists() && !repositoryFolder.isLinked(IResource.CHECK_ANCESTORS)) {
							logger.error("Cannot create repository folder: " + repositoryFolder, e);
							throw new InvocationTargetException(e);
						}
					}
				}
								
				DatabazePreLoadOperation op2 = new DatabazePreLoadOperation();
				op2.execute(monitor);
				
				isReady = true;
				
			} finally {
				monitor.done();
			}
		}		
	}
	
	private class DatabazePreLoadOperation extends WorkspaceModifyOperation {
		
		public DatabazePreLoadOperation() {
			super(element.getCorrespondingResource());
		}
		
		@Override
		protected void execute(IProgressMonitor monitor) throws CoreException,
				InvocationTargetException, InterruptedException {
			
			try {
				monitor.beginTask("", 1);
				
				element.doCacheAlternatives();				
			} catch (RepositoryException e) {
				throw new InvocationTargetException(e);
			} finally {
				monitor.done();
			}
		}
	}

	@Override
	public Job getWorkingJob() {
		return this.workingJob;
	}

	@Override
	public boolean isReady() {
		return this.isReady;
	}

	@Override
	public boolean needsInitialization() {
		if (isReady) {
			return false;
		} else if (isInitializationInProgress()) {
			return false;			
		} else {
			return true;
		}
	}
}
