/**
 * 
 */
package eu.qimpress.ide.backbone.core.internal.model;

import java.util.Date;
import java.util.UUID;

import eu.qimpress.ide.backbone.core.model.IQAlternativeInfo;
import eu.qimpress.ide.backbone.core.model.ISaveable;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * @author Michal Malohlava
 *
 */
public class QAlternativeInfoImpl implements IQAlternativeInfo, ISaveable {
	
	private static final String DEFAULT_ALTERNATIVE_DESCRIPTION = "Alternative";
	
	private boolean defaultAlternative;
	private String id;
	private String description;
	private Date creationDate;
	private IQAlternativeInfo parent;
	private String parentId; // this hack is to support underlying Object database
	
	public QAlternativeInfoImpl(String description) {
		this(null, description);
	}
	
	
	public QAlternativeInfoImpl(IQAlternativeInfo parent, String description, String SpecifiedId) {
		this.initAlternativeInfo(parent, description);	
		this.id = SpecifiedId;
	}
	
	
	public QAlternativeInfoImpl(IQAlternativeInfo parent, String description) {
		this.initAlternativeInfo(parent, description);		
	}
	
	protected void initAlternativeInfo(IQAlternativeInfo parent, String description){
		this.parent = parent;
		this.parentId = parent != null ? parent.getId() : null ;
		this.description = description != null && !"".equals(description) ? description : DEFAULT_ALTERNATIVE_DESCRIPTION;
		initDefaults();
	}
	
	protected void initDefaults() {
		this.creationDate = new Date();
		this.id = UUID.randomUUID().toString();
		this.defaultAlternative = false;
	}
	
	@Override
	public String getId() {
		return this.id;
	}

	@Override
	public String getDescription() {
		return this.description != null && !"".equals(this.description) ? this.description : DEFAULT_ALTERNATIVE_DESCRIPTION;
	}

	@Override
	public Date getCreationDate() {
		return this.creationDate;
	}

	@Override
	public IQAlternativeInfo getParent() {
		return this.parent;
	}

	@Override
	public boolean isDefault() {
		return this.defaultAlternative;
	}

	@Override
	public void setDefault(boolean shouldBeDefault) {
		this.defaultAlternative = shouldBeDefault;		
	}

	@Override
	public void save() throws RepositoryException {
		// DO NOTHING 		
	}

	// === Generated ===

	@Override
	public String toString() {
		return "QAlternativeInfoImpl [defaultAlternative=" + defaultAlternative + ", description=" + description
				+ ", id=" + id + "]";
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public String getParentId() {
		return parentId;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		QAlternativeInfoImpl other = (QAlternativeInfoImpl) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
	
}
