/*
 * (C) Copyright IBM Corp. 2002 - All Rights Reserved. 
 * Licensed Material - Property of IBM 
 */
 
package eu.qimpress.ide.backbone.core.ui.wizards;
import java.lang.reflect.InvocationTargetException;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.operations.InitializeQImpressProjectOperation;
import eu.qimpress.ide.backbone.core.ui.perspectives.QIPerspective;
import eu.qimpress.ide.backbone.core.utils.ProjectUtils;


/**
 * New Q-ImPrESS project wizard implementation.
 * 
 * @author Michal Malohlava
 */
public class QImPrESSNewProjectWizard extends BasicNewProjectResourceWizard
{	
	private final static Logger logger = Logger.getLogger(QImPrESSNewProjectWizard.class);
	
	public static final String WIZARD_ID = "eu.qimpress.ide.backbone.core.ui.QImPrESSNewProjectWizardID";
	
	public boolean performFinish() 
	{		
		if(super.performFinish()) {
			final IProject project = getNewProject();
			
			try {
				logger.trace("Trying to toggle Q-ImPrESS nature");
				
				// configure project workspace
				
				
				WorkspaceModifyOperation operation = new WorkspaceModifyOperation() {
					
					@Override
					protected void execute(IProgressMonitor monitor) throws CoreException,
							InvocationTargetException, InterruptedException {
						try {
							monitor.beginTask("", 2);
							WorkspaceModifyOperation initOperation = new InitializeQImpressProjectOperation(project);
							initOperation.run(monitor);
							// toggle Q-I nature
							ProjectUtils.toggleNature(project);
						} catch (RepositoryException e) {							
							throw new InvocationTargetException(e);
						} finally {
							monitor.done();
						}
					}
				};
								
				// execute operation
				getContainer().run(false, false, operation);
				
				getContainer().getShell().getDisplay().asyncExec( new Runnable() {
					
					@Override
					public void run() {
						// open the perspective
						IWorkbench workbench = PlatformUI.getWorkbench();
						IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
						try {
							workbench.showPerspective(QIPerspective.PERSPECTIVE_ID, window);
						} catch (WorkbenchException e) {							
							logger.warn("Cannot open Q-ImPrESS perspective.", e);
						}						
					}
				});
				
			} catch (Exception e) {
				logger.error("Cannot toggle Q-Impress nature for project " + project, e);
				MessageDialog.openError(getShell(), "Q-ImPrESS project creation failed", "Q-ImPrESS nature toggling failed - see log for details");
				
				// TODO rollback - delete the created project
			}
			
			return true;
		}
		
		return false;
	}
}
