/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.operations.CreateQAlternativeUIOperation;

/**
 * @author Michal Malohlava
 *
 */
public class NewQAlternativeWizard extends Wizard implements INewWizard {
	
	public static final Logger logger = Logger.getLogger(NewQAlternativeWizard.class);
	
	public static final String WIZARD_ID = "eu.qimpress.ide.backbone.core.ui.NewAlternativeWizardID";
	
	private NewQAlternativePage page;
	private IStructuredSelection initialSelection;

	/**
	 * 
	 */
	public NewQAlternativeWizard() {
		setWindowTitle("New alternative");
		setNeedsProgressMonitor(false);
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		final String alternativeName = page.getAlternativeName();
		final Object alternativeParent = page.getAlternativeParentSelection().getFirstElement();
		
		try {
			CreateQAlternativeUIOperation operation = new CreateQAlternativeUIOperation(alternativeName, alternativeParent);
			
			getContainer().run(false, false, operation);
		} catch (Exception e) {
			MessageDialog.openError(getShell(), "Error occured", "Cannot create new alternative because of " + e.getMessage());
			logger.error("Alternative creation failed", e);			
		}
				
		return true;
	}
	
	
	
	@Override
	public void addPages() {
		IQElement parentElement = null;
		
		if (initialSelection.size() == 1) {
			if (initialSelection.getFirstElement() instanceof IQAlternative ||
				initialSelection.getFirstElement() instanceof IQRepository	) {
				parentElement = (IQElement) initialSelection.getFirstElement();
			}
		}
		
		
		page = new NewQAlternativePage(parentElement);
		addPage(page);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.initialSelection = selection;		
	}
}
