/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.widgets.Composite;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider.ContentFilterEnum;

/**
 * Tree viewer for selecting Projects.
 * 
 * The viewer allows selection of single of mutliple Projects according to a
 * configuration.
 * 
 * @author Michal Malohlava
 * 
 */

public class QProjectViewer extends CheckboxTreeViewer {
	
	private List<IQProject> selectedProjects = null;

	public QProjectViewer(Composite parent, int style) {
		this(parent, style, true);
	}
	
	public IQProject getFirstSelectedProject() {
		if ((selectedProjects == null) || (selectedProjects.size() == 0)) {
			return null;
		}
		return selectedProjects.get(0);
	}

	public QProjectViewer(Composite parent, int style,
			final boolean singleSelection) {
		super(parent, style);
		this.addCheckStateListener(new ICheckStateListener() {
			@SuppressWarnings("restriction")
			public void checkStateChanged(CheckStateChangedEvent event) {	
				
				if (singleSelection) {
					if (event.getChecked() == false) {
						setCheckedElements(new Object[] {});
						selectedProjects = new ArrayList<IQProject>();
					} else {
						setCheckedElements(new Object[] { event
								.getElement() });
						selectedProjects = new ArrayList<IQProject>();
						IQProject project = QImpressApplicationModelManager.getManager().getQAppModel().getQProject((IProject)event.getElement());
						selectedProjects.add(project);
					}
				} else {
					Object[] checkedElements = getCheckedElements();
					selectedProjects = new ArrayList<IQProject>();
					for (int i = 0; i < getCheckedElements().length; i++) {
						IQProject project = QImpressApplicationModelManager.getManager().getQAppModel().getQProject((IProject) checkedElements[i]);
						selectedProjects.add(project);
					}
				}
			}
		});
		
		//content provider
		this.setContentProvider(new QAppNavigatorContentProvider(
				ContentFilterEnum.FILTER_PROJECTS_ONLY.val()));
		//input
		this.setInput(QImpressApplicationModelManager.getManager().getQAppModel());
		
		//label provider
		this.setLabelProvider(new QAppNavigatorLabelProvider());
				
	}
	
	public void selectElement(IQProject project) {
		//expandToLevel(Project, ALL_LEVELS);
		setCheckedElements(new Object[] { project});
		selectedProjects = new ArrayList<IQProject>();
		selectedProjects.add(project);
	}
	
	public List<IQProject> getSelectedProjects() {
		if( selectedProjects == null)
		{
			return Collections.emptyList();
		}
		
		return selectedProjects;
	}
}
