/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.widgets.Composite;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQRepository;

/**
 * Tree viewer for selecting alternatives.
 * 
 * The viewer allows selection of single of mutliple alternatives according to a
 * configuration.
 * 
 * @author Michal Malohlava
 * 
 */
public class QAlternativesCheckBoxTreeViewer extends CheckboxTreeViewer {
	
	private List<IQAlternative> selectedAlternatives = null;
	
	private boolean canSelectRepository = false;

	protected QAlternativesCheckBoxTreeViewer(Composite parent, int style) {
		this(parent, style, true);
	}
	
	public IQAlternative getFirstSelectedAlternative() {
		if ((selectedAlternatives == null) || (selectedAlternatives.size() == 0)) {
			return null;
		}
		return selectedAlternatives.get(0);
	}

	protected QAlternativesCheckBoxTreeViewer(Composite parent, int style,
			final boolean singleSelection) {
		super(parent, style);
		
		// When user checks a checkbox in the tree, check all its children
		this.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {	
				if (!singleSelection) {
					// If the item is checked...
					if (event.getChecked()) {
						// check all its children
						QAlternativesCheckBoxTreeViewer.this.setSubtreeChecked(
								event.getElement(), true);
					}
					selectedAlternatives = new ArrayList<IQAlternative>();
					Object[] checkedElements = getCheckedElements();
					for (int i = 0; i < getCheckedElements().length; i++) {
						if ((checkedElements[i]) instanceof
								IQAlternative) {
							selectedAlternatives.add((IQAlternative) checkedElements[i]);
						}
					}
				}
				
				if (singleSelection) {
					if (!(event.getElement() instanceof IQAlternative)) {
						if (event.getElement() instanceof IQRepository){
							if (event.getChecked()) {
								setChecked(event.getElement(), true);
							}
						}else {
							if (event.getChecked()) {
								setChecked(event.getElement(), false);
							}
						}
					} else {
						if (event.getChecked() == false) {
							setCheckedElements(new Object[] {});
							
							selectedAlternatives = new ArrayList<IQAlternative>();
						} else {
							setCheckedElements(new Object[] { event
									.getElement() });
							selectedAlternatives = new ArrayList<IQAlternative>();
							selectedAlternatives.add((IQAlternative) event
									.getElement());
						}
					}
				}
			}
		});
		
				
	}
	
	public void selectElement(IQAlternative alternative) {
		expandToLevel(alternative, ALL_LEVELS);
		setCheckedElements(new Object[] { alternative});
		selectedAlternatives = new ArrayList<IQAlternative>();
		selectedAlternatives.add(alternative);
	}

	public void setCanSelectRepository(boolean canSelectRepository) {
		this.canSelectRepository = canSelectRepository;
	}

	public boolean isCanSelectRepository() {
		return canSelectRepository;
	}
	
	public List<IQAlternative> getSelectedAlternatives() {
		if( selectedAlternatives == null)
		{
			return Collections.emptyList();
		}
		return selectedAlternatives;
	}
}
