/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchContentProvider;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import eu.qimpress.ide.backbone.core.ui.internal.ChainedLabelProvider;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.provider.ResultModelItemProviderAdapterFactory;

/**
 * Factory for configuration of {@link AlternativeEvaluation}
 * 
 * @author Michal Malohlava
 *
 */
public class QAlternativeEvaluationSelectorWidgetFactory extends AbstractWidgetFactory<CheckboxTreeViewer> {
	
	private static final int TREE_DEFAULT_STYLE = SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.VIRTUAL;
	
	private static final String[] NO_ALTERNATIVE_EVALUATION_WARNING = new String[] { "<no alternative evaluation>"};
	
	private boolean onlySingleSelection = true;
	
	protected QAlternativeEvaluationSelectorWidgetFactory(CheckboxTreeViewer tableViewer) {
		super(tableViewer);
	}
	
	public static QAlternativeEvaluationSelectorWidgetFactory createWidgetFactory(Composite parent) {
		return createWidgetFactory(parent, null);
	}
	
	public static QAlternativeEvaluationSelectorWidgetFactory createWidgetFactory(Composite parent, IProject project) {
		QAlternativeEvaluationSelectorWidgetFactory factory = createWidgetFactory(parent, TREE_DEFAULT_STYLE, QAlternativeEvaluationSelectorWidgetFactory.class, CheckboxTreeViewer.class);
		
		if (project != null) {
			factory.widget.setInput(QImpressCore.getQProject(project));
		}
		
		return factory; 
	}
	
	public void setOnlySingleSelection(boolean s) {
		this.onlySingleSelection = s;
	}
	
	@Override
	protected void finalizeWidget() {
		// add selection listener
		this.widget.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				Object element = event.getElement();
				
				if (onlySingleSelection) {					
					
					if (element instanceof AlternativeEvaluation) {						
						if (event.getChecked() == false) {
							widget.setCheckedElements(new Object[] {});
							
						} else {
							widget.setCheckedElements(new Object[] { event.getElement() });
						}
					} else {
						widget.setChecked(element, false);
					}
				}
			}
		});
	}
	
	
	@Override
	protected void configureWidget() {
				
		// setup content providers
		this.widget.setContentProvider(new AlternativeEvaluationNavigatorProvider());		
		this.widget.setLabelProvider(new ChainedLabelProvider( 
											new QAppNavigatorLabelProvider(),
											new ChainedLabelProvider(
													new AdapterFactoryLabelProvider(new ResultModelItemProviderAdapterFactory())
											)
									));
		
		this.widget.setInput(QImpressApplicationModelManager.getManager().getQAppModel());	
	}
	
	/**
	 * Content provider showing only Projects and included AlternativeEvaluations.
	 * 
	 * @author Michal Malohlava
	 *
	 */
	public static class AlternativeEvaluationNavigatorProvider extends WorkbenchContentProvider {
		
		private static final Object[] NO_CHILDREN = new Object[0];
		
		private boolean showNoAlternativeEvaluationWarning = true;
						
		@Override
		public Object[] getChildren(Object element) {
			if (element instanceof IQProject) {
				Object[] result;
				try {
					result = ((IQProject) element).getRepository().getAllAlternativeEvaluations().toArray();										
				} catch (RepositoryException e) {
					result = NO_CHILDREN;
				}
				
				if (result.length == 0 && showNoAlternativeEvaluationWarning) {
					return NO_ALTERNATIVE_EVALUATION_WARNING; 					
				} else {
					return result;					
				} 												
			}				
				
			return super.getChildren(element);
		}		
		
		@Override
		public Object[] getElements(Object element) {			
			if (element instanceof IQApplicationModel) {
				IQApplicationModel qAppModel = (IQApplicationModel) element;
				
				return qAppModel.getQProjects();
			}
			
			return super.getElements(element);
		}		
	}

	public static void applyFilterFor(final IQAlternative alternative, final CheckboxTreeViewer treeViewer) {
		treeViewer.setFilters(new ViewerFilter[] {
				new ViewerFilter() {
					
					@Override
					public boolean select(Viewer viewer, Object parentElement, Object element) {
												
						if (element instanceof IQProject ) {
							if ( ((IQProject) element).equals(alternative.getRepository().getQProject())) {
								return true;
							}
						/*
						} else if (element instanceof IQAlternative) {
							if ( ((IQAlternative) element).equals(alternative)) {
								return true;
							}*/							
						} else if (element instanceof AlternativeEvaluation) {
							return true;
						} else if (element instanceof String) {
							return true;
						}
						
						return false;
					}							
				}
			});		
	}
}
