/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import java.lang.reflect.Constructor;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

/**
 * 
 * @author Michal Malohlava
 *
 * @param <T> type of widget to create
 */
abstract public class AbstractWidgetFactory<T extends Viewer> implements IWidgetFactory<T> {
	
	private static final Logger logger = Logger.getLogger(AbstractWidgetFactory.class);
	
	protected T widget;
	
	protected AbstractWidgetFactory(T widget) {
		this.widget = widget;		
	}
	
	protected static <F extends AbstractWidgetFactory, W extends Viewer> F createWidgetFactory(Composite c, int style, Class<F> factoryClazz, Class<W> widgetClazz) {
		try {
			Constructor<W> wConstructor = widgetClazz.getDeclaredConstructor(Composite.class, int.class);
			W widget = wConstructor.newInstance(c, style);
			
			Constructor<F> fConstructor = factoryClazz.getDeclaredConstructor(widgetClazz);
			F factory = fConstructor.newInstance(widget);
			
			factory.configureWidget();
			
			return factory;
			
		} catch (Exception e) {
			logger.error("Cannot create widget factory", e);			
		}
		
		return null;
	}
	
	protected abstract void configureWidget();
	
	protected abstract void finalizeWidget();
	
	@Override
	public T getWidget() {
		finalizeWidget();
		
		return this.widget;
	}		
}
