package eu.qimpress.ide.backbone.core.ui.internal;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * 
 * @author Michal Malohlava
 *
 */
public class QInitializationAfterStartJob extends UIJob {
	
	private static final String JOB_NAME = "Q-ImPrESS Backbone Initialization Job";
	private static final Logger logger = Logger.getLogger(QInitializationAfterStartJob.class);

	public QInitializationAfterStartJob() {
		super(JOB_NAME);
		setSystem(true);
	}
	
	@Override
	public IStatus runInUIThread(IProgressMonitor monitor) {
		Job job = new RealJob(JOB_NAME);
		job.setPriority(Job.SHORT);
		job.schedule();		
		
		return new Status(IStatus.OK, QImpressCore.PLUGIN_ID, IStatus.OK, "", null);
	}

	private class RealJob extends Job {
		
		public RealJob(String name) {
			super(name);
		}

		@Override
		protected IStatus run(IProgressMonitor monitor) {
			logger.trace(JOB_NAME + " has started.");
			
			IQProject[] qProjects = QImpressApplicationModelManager.getManager().getQAppModel().getQProjects();
						
			try {				
				monitor.beginTask(JOB_NAME, qProjects.length);
				
				for (IQProject qProject : qProjects) {
					try {
						IQRepository repository = qProject.getRepository();
						
						IQWorkspaceController repositoryController = (IQWorkspaceController) repository.getAdapter(IQWorkspaceController.class);
						if (repositoryController != null) {
							repositoryController.init(false, true);
						}
						monitor.worked(1);
						
					} catch (RepositoryException e) {
						logger.warn("Cannot initialize Q-ImPrESS project: " + qProject, e);				
					} 			
				}				
			} finally {
				monitor.done();
				// refresh the view
				QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
				logger.trace(JOB_NAME + " has finished.");
			}
			
			return new Status(IStatus.OK, QImpressCore.PLUGIN_ID, IStatus.OK, "", null);
		}
		
		@Override
		public boolean belongsTo(Object family) {			
			return QImpressCore.PLUGIN_ID.equals(family);
		}
	}
}
