/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;

import eu.qimpress.ide.backbone.core.ui.QImpressUICore;

/**
 * @author Michal Malohlava
 *
 */
public final class QImpressUICorePluginImages {
	/** Image top-level directory */
	public static final String IMAGE_MAIN_DIR = "icons";
	
	/* Image names 
	 * 
	 * Icons were downloaded from http://www.iconlet.com/
	 * They are lincesed under EPL or free.
	 */
	public static final String IMG_REPO_DEFAULT = "repository-yellow.gif";
	public static final String IMG_REPO_STATIC_STRUCTURE = "repository-blue.png";
	public static final String IMG_ALTERNATIVES = "alternatives.gif";	
	public static final String IMG_DEFAULT_ALTERNATIVE = "alternative-default.gif";
	public static final String IMG_GLOBAL_ALTERNATIVE = "alternative-global.png";
	public static final String IMG_ALTERNATIVE = "alternative.gif";
	
	public static final String IMG_QIMPRESS_LOGO = "qimpress-logo.png";
	public static final String IMG_QIMPRESS_LOGO_OVR = "qimpress-logo.gif";
	
	public static final String IMG_RED_DELETE = "red_delete.gif";
	
	/* Image types - see http://wiki.eclipse.org/UIGraphicsImplementationFolderStructure for naming convention */
	public static final String T_MODEL_OBJECTS = "obj16";
	public static final String T_OVERLAYS = "ovr16";
	public static final String T_ENABLE_LOCAL_TOOLBARS = "elcl16";
	public static final String T_TOOLBAR = "etool16";
	
	/* Cached image descriptors */
	public static final ImageDescriptor DESC_REPO_DEFAULT = createImageDescriptor(T_MODEL_OBJECTS, IMG_REPO_DEFAULT);
	public static final ImageDescriptor DESC_REPO_STATIC_STRUCTURE = createImageDescriptor(T_MODEL_OBJECTS, IMG_REPO_STATIC_STRUCTURE);
	public static final ImageDescriptor DESC_ALTERNATIVES = createImageDescriptor(T_MODEL_OBJECTS, IMG_ALTERNATIVES);
	public static final ImageDescriptor DESC_DEFAULT_ALTERNATIVE = createImageDescriptor(T_MODEL_OBJECTS, IMG_DEFAULT_ALTERNATIVE);
	public static final ImageDescriptor DESC_GLOBAL_ALTERNATIVE = createImageDescriptor(T_MODEL_OBJECTS, IMG_GLOBAL_ALTERNATIVE);;
	public static final ImageDescriptor DESC_ALTERNATIVE = createImageDescriptor(T_MODEL_OBJECTS, IMG_ALTERNATIVE);;
	public static final ImageDescriptor DESC_QIMPRESS_LOGO = createImageDescriptor(T_MODEL_OBJECTS, IMG_QIMPRESS_LOGO);
	public static final ImageDescriptor DESC_RED_DELETE = createImageDescriptor(T_TOOLBAR, IMG_RED_DELETE);
	
	/* overlays */
	public static final ImageDescriptor DESC_QIMPRESS_OVERLAY = createImageDescriptor(T_OVERLAYS, IMG_QIMPRESS_LOGO_OVR);
	
	protected static final ImageDescriptor createImageDescriptor(String type, String key) {
		// TODO implement cache for images 
		return QImpressUICore.getImageDescriptor(IMAGE_MAIN_DIR + "/" + type + "/" + key);		
	}
	
}
