/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal;


import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;

/**
 * @author Michal Malohlava
 */
public class QAppWorkbenchAdapter implements IWorkbenchAdapter {
	
	public final static String RESULT_MODEL_LABEL = "RESULTS";
	public static final String GLOBAL_MODELS_LABEL = "COMMON MODELS";
	
	protected static final Object[] NO_CHILDREN = new Object[0];

	@Override
	public Object[] getChildren(Object o) {
		return NO_CHILDREN;
	}

	@Override
	public ImageDescriptor getImageDescriptor(Object object) {
		IQElement element = getQElement(object);
		if (element == null) {
			return null;
		}
		
		switch (element.getElementType()) {			
			case Q_REPOSITORY:
				return QImpressUICorePluginImages.DESC_ALTERNATIVES;
			case Q_MODEL:
				// TODO return different images according to model 
				return QImpressUICorePluginImages.DESC_REPO_STATIC_STRUCTURE;
			case Q_ALTERNATIVE:
				if (((IQAlternative) element).getInfo().isDefault()) 
					return QImpressUICorePluginImages.DESC_DEFAULT_ALTERNATIVE;
				else if(QImpressCore.isGlobalAlternative((IQAlternative) element)) 
					return QImpressUICorePluginImages.DESC_GLOBAL_ALTERNATIVE;
				else
					return QImpressUICorePluginImages.DESC_ALTERNATIVE;
			default:
				return null;
		}		
	}

	@Override
	public String getLabel(Object o) {
		IQElement element = getQElement(o);		
		if (element == null) {
			return null;
		}
		
		switch (element.getElementType()) {
		case Q_REPOSITORY:
			return "> Alternatives repository <";
		case Q_MODEL:
			if (((IQModel) element).getType().equals(RepositoryModels.RESULT_MODEL_EXT)) {
				return RESULT_MODEL_LABEL;
			} else {				
				return ((IQModel) element).getName();
			}
		case Q_ALTERNATIVE:
			if (QImpressCore.isGlobalAlternative((IQAlternative) element)) 
				return GLOBAL_MODELS_LABEL;
			else
				return ((IQAlternative) element).getInfo().getDescription();
		default:
			return null;
		}
	}

	@Override
	public Object getParent(Object o) {
		IQElement element = getQElement(o);
		
		return element != null ? element.getParent() : null;
	}
	
	private IQElement getQElement(Object element) {
		if (element instanceof IQElement) {
			return (IQElement) element;
		}
		
		if (element instanceof IAdaptable) {
			return (IQElement) ((IAdaptable) element).getAdapter(IQElement.class);
		}
		
		return null;
	}

}
