/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal;


import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;

import eu.qimpress.ide.backbone.core.model.IQProject;

/**
 * @author Michal Malohlava
 *
 */
public class QAppProjectAdapterFactory implements IAdapterFactory {
	
	@SuppressWarnings("unchecked")
	private static final Class[] SUPPORTED_ADAPTERS = new Class[] {
		IProject.class
	};

	@Override
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (IProject.class.equals(adapterType)) {
			IQProject qAppProject = (IQProject) adaptableObject;
			return qAppProject.getProject();			
		}
		
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Class[] getAdapterList() {
		return SUPPORTED_ADAPTERS;
	}
}
