/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;

/**
 * Simple type wrapping default alternative.
 * 
 * @author Michal Malohlava
 *
 */
public class DefaultAlternativeWrapper extends PlatformObject implements IAdaptable {
	
	private IQAlternative defaultAlternative;
	
	public DefaultAlternativeWrapper(IQAlternative defaultAlternative) {
		this.setDefaultAlternative(defaultAlternative);
	}

	public void setDefaultAlternative(IQAlternative defaultAlternative) {
		this.defaultAlternative = defaultAlternative;
	}

	public IQAlternative getDefaultAlternative() {
		return defaultAlternative;
	}
	
	boolean isSet() {
		return defaultAlternative == null;
	}

	@Override
	public Object getAdapter(Class adapter) {
		
		if (IQElement.class.equals(adapter)
				|| IQAlternative.class.equals(adapter)) {
			return this.defaultAlternative;
		}
		
		if (this.defaultAlternative != null){
			return this.getDefaultAlternative().getAdapter(adapter);
		}
		
		return super.getAdapter(adapter);
	}
}
