/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

/**
 * @author Michal Malohlava
 *
 */
public class ChainedLabelProvider implements ILabelProvider {
	
	private ChainedLabelProvider next;
	private ILabelProvider labelProvider;
	
	public ChainedLabelProvider(ILabelProvider provider) {
		this(provider, null);
	}
	
	public ChainedLabelProvider(ILabelProvider provider, ChainedLabelProvider next) {
		this.labelProvider = provider;
		this.next = next;
	}

	@Override
	public Image getImage(Object element) {
		Image result = labelProvider.getImage(element);
		
		if (result == null && next != null) {
			return next.getImage(element);
		}
		
		return result;
	}

	@Override
	public String getText(Object element) {
		String result = labelProvider.getText(element);
		
		if ((result == null || "".equals(result)) && next != null) {
			return next.getText(element);
		}
		
		return result;
	}

	@Override
	public void addListener(ILabelProviderListener listener) {
		labelProvider.addListener(listener);
		if (next != null) {
			next.addListener(listener);
		}
	}

	@Override
	public void dispose() {
		if (next != null) {
			next.dispose();
		}
		
		labelProvider.dispose();
	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		boolean result = labelProvider.isLabelProperty(element, property);
		if (!result && next != null) {
			return next.isLabelProperty(element, property);
		}
		
		return result;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {
		if(next !=null) {
			next.removeListener(listener);
		}
		labelProvider.removeListener(listener);
	}

}
